package com.yeejoin.amos.boot.module.tzs.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import lombok.Data;
import lombok.EqualsAndHashCode;
import java.util.Date;

/**
 * 派遣任务
 *
 * @author kongfm
 * @date 2021-08-03
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value="DispatchTaskDto", description="派遣任务")
public class DispatchTaskDto  extends BaseDto {

   private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "是否救援任务")
    private Boolean isSaveTask;

    @ApiModelProperty(value = "警情id")
    private Long alertId;

    @ApiModelProperty(value = "派遣单id")
    private Long paperId;

    @ApiModelProperty(value = "组织code")
    private String orgCode;

    @ApiModelProperty(value = "派遣单位类型")
    private String orgType;

    @ApiModelProperty(value = "派遣单位类型code 使用单位/维保单位/三级响应")
    private String orgTypeCode;

    @ApiModelProperty(value = "响应单位id")
    private Long responseOrgId;

    @ApiModelProperty(value = "响应单位名称")
    private String responseOrgName;

    @ApiModelProperty(value = "响应人员id")
    private Long responseUserId;

    @ApiModelProperty(value = "响应人员名称")
    private String responseUserName;

    @ApiModelProperty(value = "响应人员电话")
    private String responseUserTel;

    @ApiModelProperty(value = "派遣时间")
    private Date dispatchTime;

    @ApiModelProperty(value = "通知方式")
    private String dispatchInfoType;

    @ApiModelProperty(value = "通知方式code")
    private String dispatchInfoCode;

    @ApiModelProperty(value = "派遣内容")
    private String dispatchContext;

    @ApiModelProperty(value = "到达时间")
    private Date arriveTime;

    @ApiModelProperty(value = "任务状态")
    private String taskStatus;

    @ApiModelProperty(value = "警情类型code")
    private String alertCode;

}
