package com.yeejoin.amos.boot.module.tzs.api.service;


import com.yeejoin.amos.boot.module.tzs.api.dto.DispatchConsultFeedbackDto;
import com.yeejoin.amos.boot.module.tzs.api.dto.DispatchPaperFormDto;
import com.yeejoin.amos.boot.module.tzs.api.dto.DispatchRepairFeedbackDto;
import com.yeejoin.amos.boot.module.tzs.api.dto.DispatchSaveFeedbackDto;
import com.yeejoin.amos.boot.module.tzs.api.entity.DispatchPaper;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;

/**
 * 派遣单接口类
 *
 * @author kongfm
 * @date 2021-08-03
 */
public interface IDispatchPaperService {

    DispatchPaper selectDispatchPaperByAlertId(Long alertId);

    DispatchPaperFormDto selectDispatchPaperDtoByAlertId(Long alertId);

    /**
     * 根据警情id 及 警情类别 派遣人 创建 派遣单
     * @param alertId
     * @param alertCode
     * @param sendUser
     * @return
     */
    DispatchPaperFormDto createDispatchPaper(Long alertId, String alertCode, AgencyUserModel sendUser);

    /**
     * 根据警情id 返回 救援回访相关信息
     * @param alertId
     * @return
     */
    DispatchSaveFeedbackDto getDispatchSaveFeedbackDtoByAlertId(Long alertId, AgencyUserModel feedbackUser);

    /**
     * 坐席填写救援回访相关信息
     * @param dispatchSaveFeedbackDto
     * @return
     */
    Boolean saveDispatchSaveFeedback(DispatchSaveFeedbackDto dispatchSaveFeedbackDto);

    /**
     * 根据警情id 返回 维修回访相关信息
     * @param alertId
     * @return
     */
    DispatchRepairFeedbackDto getDispatchRepairFeedbackDtoByAlertId(Long alertId, AgencyUserModel feedbackUser);


    /**
     * 坐席填写维修回访相关信息
     * @param dispatchRepairFeedbackDto
     * @return
     */
    Boolean saveDispatchRepairFeedback(DispatchRepairFeedbackDto dispatchRepairFeedbackDto);

    /**
     * 根据警情id 返回 投诉回访相关信息
     * @param alertId
     * @return
     */
    DispatchConsultFeedbackDto getDispatchConsultFeedbackDtoByAlertId(Long alertId, AgencyUserModel feedbackUser);


    /**
     * 坐席填写投诉回访相关信息
     * @param dispatchConsultFeedbackDto
     * @return
     */
    Boolean saveDispatchConsultFeedback(DispatchConsultFeedbackDto dispatchConsultFeedbackDto);


}
