package com.yeejoin.amos.boot.module.common.biz.controller;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.common.api.dto.AttachmentDto;
import com.yeejoin.amos.boot.module.common.api.dto.KeySiteDto;
import com.yeejoin.amos.boot.module.common.api.dto.OrgMenuDto;
import com.yeejoin.amos.boot.module.common.api.entity.KeySite;
import com.yeejoin.amos.boot.module.common.api.service.IKeySiteService;
import com.yeejoin.amos.boot.module.common.api.service.IOrgUsrService;
import com.yeejoin.amos.boot.module.common.biz.service.impl.KeySiteServiceImpl;
import com.yeejoin.amos.boot.module.common.biz.service.impl.SourceFileServiceImpl;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

/**
 * 重点部位
 *
 * @author system_generator
 * @date 2021-07-26
 */
@RestController
@Api(tags = "重点部位Api")
@RequestMapping(value = "/common/key-site")
public class KeySiteController extends BaseController {

    @Autowired
    KeySiteServiceImpl keySiteServiceImpl;
    @Autowired
    IKeySiteService keySiteService;
    
    @Autowired
	IOrgUsrService iOrgUsrService;
    
    @Autowired
	SourceFileServiceImpl sourceFileService;
    /**
     * 新增重点部位
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增重点部位", notes = "新增重点部位")
	public ResponseModel<KeySiteDto> save(@RequestBody KeySiteDto model) {
    	model.setIsDelete(false);
    	KeySiteDto entity=	keySiteService.save(model);
	    return ResponseHelper.buildResponse(entity);
	}

	/**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PutMapping(value = "update/{sequenceNbr}")
	@ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新重点部位", notes = "根据sequenceNbr更新重点部位")
	public ResponseModel<Boolean> updateBySequenceNbrKeySite(@RequestBody KeySiteDto model ) {
	    return ResponseHelper.buildResponse(keySiteService.update(model, getUserInfo()));
	}

	/**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "delete")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除重点部位", notes = "根据sequenceNbr删除重点部位")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request,@RequestParam(value = "sequenceNbrList") List<Long> sequenceNbrList){
        return ResponseHelper.buildResponse(keySiteService.deleteById(sequenceNbrList));
    }

    /**
     * 根据sequenceNbr查询
     *
	 * @param sequenceNbr  主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "find/{sequenceNbr}")
	@ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询单个重点部位",  notes = "根据sequenceNbr查询单个重点部位")
	public ResponseModel<KeySiteDto> selectOne(@PathVariable Long sequenceNbr) {
		List<String> list = new ArrayList<String>();
		Map<String, List<AttachmentDto>> files = sourceFileService.getAttachments(sequenceNbr);
		KeySiteDto dto=  keySiteService.getSequenceNbr(sequenceNbr);
		if(files!=null && dto!=null) {
			dto.setAttachments(files);
			JSONArray array=	JSONArray.parseArray(JSONArray.toJSONString(files.get("keySitePhoto")));
			if(array!=null &&array.size()>0) {
				for(Object i :array) {
					JSONObject object = JSONObject.parseObject(JSONObject.toJSONString(i));
					list.add(object.getString("url"));
				}
			}
		}
		dto.setAttachmentsList(list);
	    return ResponseHelper.buildResponse(dto);
	}

	/**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/page")
	@ApiOperation(httpMethod = "GET",value = "重点部位分页查询",  notes = "重点部位分页查询")
	public ResponseModel<IPage<KeySiteDto>> queryForPage(@RequestParam(value = "current") int current,@RequestParam
                    (value = "size") int size,@RequestParam(required = false)  String  name,@RequestParam(required = false) Long buildingId,@RequestParam(required = false)  String fireEnduranceRate,
                    @RequestParam(required = false)  String useNature,@RequestParam(required = false)   String fireFacilitiesInfo,@RequestParam(required = false)  Long belongId) {
	    Page<KeySiteDto> page = new Page<KeySiteDto>();
	    page.setCurrent(current);
	    page.setSize(size);
	    return ResponseHelper.buildResponse(keySiteServiceImpl.getPageList(page,name,buildingId,fireEnduranceRate,useNature,fireFacilitiesInfo,belongId));
	}

	/**
	 * 列表全部数据查询
     *
	 * @return
	 */
//	@TycloudOperation(ApiLevel = UserType.AGENCY)
//	@ApiOperation(httpMethod = "GET",value = "重点部位列表全部数据查询",   notes = "重点部位列表全部数据查询")
//	@GetMapping(value = "/list")
//	public ResponseModel<List<KeySite>> selectForList() {
//	    return ResponseHelper.buildResponse(keySiteServiceImpl.queryForKeySiteList());
//	}
	
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "机场单位部位树",   notes = "机场单位部位树")
	@GetMapping(value = "/getOrguserTree")
	public  ResponseModel<List<OrgMenuDto>> getOrguserTree() {
		List<OrgMenuDto> list = new ArrayList<OrgMenuDto>();
		OrgMenuDto orgMenuDto =new OrgMenuDto();
		orgMenuDto.setChildren(keySiteService.getOrguserTree());
		orgMenuDto.setName("单位管理");
		orgMenuDto.setKey(-1L);
		orgMenuDto.setTitle("单位管理");
		list.add(orgMenuDto);
 		return ResponseHelper.buildResponse(list);
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "建筑部位树",   notes = "建筑部位树")
	@GetMapping(value = "/getBuildTree/{buildingId}")
	public  ResponseModel<List<OrgMenuDto>> getBuildTree(@PathVariable Long buildingId) {
 		return ResponseHelper.buildResponse(keySiteService.getBuildAndKeyTree(buildingId));
	}
}
