package com.yeejoin.amos.fas.business.controller;

import java.util.Date;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import com.yeejoin.amos.fas.business.service.intfc.IStationMaintenService;
import com.yeejoin.amos.fas.config.Permission;
import com.yeejoin.amos.fas.core.util.CommonResponse;
import com.yeejoin.amos.fas.core.util.CommonResponseUtil;
import com.yeejoin.amos.fas.dao.entity.StationInfo;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

@RestController
@RequestMapping(value = "/api/stationMainten")
@Api(tags="站端api")
public class StationMaintenController extends AbstractBaseController{

    @Autowired
    private IStationMaintenService stationMaintenService;

    /**
     * 保存站端信息
     */
    @Permission
    @ApiOperation(value = "保存录入站端信息", notes = "保存录入站端信息")
    @PostMapping(value = "/save")
    public CommonResponse saveStation(@RequestBody StationInfo stationParams) {

        AgencyUserModel userModel = getUserInfo();
        stationParams.setCreateBy(getUserId());
        stationParams.setCreateDate(new Date());
        stationParams.setCreateUserName(userModel.getUserName());
        stationParams.setCreateUserPhoneNum(userModel.getMobile());

        stationMaintenService.save(stationParams);
        return CommonResponseUtil.success();
    }

    /**
     * 获取站端信息
     */
    @Permission
    @ApiOperation(value = "获取站端信息", notes = "获取站端信息")
    @PostMapping(value = "/detail")
    public CommonResponse detail() {
        StationInfo stationInfo = stationMaintenService.detail();
        return CommonResponseUtil.success(stationInfo);
    }

}
