package com.yeejoin.amos.fas.business.util;


import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;

/**
 * 
 * <pre>
 * JSON宸ュ叿绫�
 * </pre>
 *
 * @author dell
 * @version $Id: JSONUtil.java, v 0.1 2017骞�3鏈�28鏃� 涓嬪崍9:04:47 dell Exp $
 */
public class JSONUtil
{

	private static Gson gson = null;

	static
	{
		gson = new Gson();
	}

	public static synchronized Gson newInstance()
	{
		if (gson == null)
		{
			gson = new Gson();
		}
		return gson;
	}

	public static String toJson(Object obj)
	{
		return gson.toJson(obj);
	}

	public static <T> T toBean(String json, Class<T> clz)
	{

		return gson.fromJson(json, clz);
	}

	public static <T> Map<String, T> toMap(String json, Class<T> clz)
	{
		Map<String, JsonObject> map = gson.fromJson(json,
				new TypeToken<Map<String, JsonObject>>() {
				}.getType());
		Map<String, T> result = new HashMap<>();
		for (String key : map.keySet())
		{
			result.put(key, gson.fromJson(map.get(key), clz));
		}
		return result;
	}

	public static Map<String, Object> toMap(String json)
	{
		Map<String, Object> map = gson.fromJson(json,
				new TypeToken<Map<String, Object>>() {
				}.getType());
		return map;
	}

	public static <T> List<T> toList(String json, Class<T> clz)
	{
		JsonArray array = new JsonParser().parse(json).getAsJsonArray();
		List<T> list = new ArrayList<>();
		for (final JsonElement elem : array)
		{
			list.add(gson.fromJson(elem, clz));
		}
		return list;
	}

}

