package com.yeejoin.amos.knowledgebase.controller;

import com.yeejoin.amos.knowledgebase.face.model.KnowledgeDocCommentsModel;
import com.yeejoin.amos.knowledgebase.face.service.DocCommentsService;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.context.RequestContext;
import org.typroject.tyboot.core.foundation.utils.StringUtil;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.doc.TycloudResource;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.exception.instance.BadRequest;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.List;

/**
 * <p>
 * 知识库评论信息 前端控制器
 * </p>
 *
 * @author 子杨
 * @since 2020-08-05
 */

@RestController
@TycloudResource(module = "knowledgebase", value = "doccomments")
@RequestMapping(value = "/v1/doccomments")
@Api(tags = "knowledgebase-知识库评论信息")
public class DocCommentsResource {

    private final Logger logger = LogManager.getLogger(DocCommentsResource.class);
    @Autowired
    private DocCommentsService docCommentsService;


    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "创建评论")
    @RequestMapping(value = "", method = RequestMethod.POST)
    public ResponseModel<KnowledgeDocCommentsModel> create(@RequestBody KnowledgeDocCommentsModel model) {
        if (ValidationUtil.isEmpty(model)
                || ValidationUtil.isEmpty(model.getDocSeq())
                || ValidationUtil.isEmpty(model.getCommentsContent()))
            throw new BadRequest("参数校验失败.");

        return ResponseHelper.buildResponse(docCommentsService.createComments(model));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "批量删除评论")
    @RequestMapping(value = "/{ids}", method = RequestMethod.DELETE)
    public ResponseModel deleteComments(
            @PathVariable(value = "ids") String ids) {
        List<Long> seqs = StringUtil.String2LongList(ids);
        docCommentsService.deleteBatchSeq(seqs);
        return ResponseHelper.buildResponse(seqs);
    }


    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "给评论点赞")
    @RequestMapping(value = "/{sequenceNbr}/like", method = RequestMethod.PUT)
    public ResponseModel<Boolean> like(
            @PathVariable(value = "sequenceNbr") Long sequenceNbr) {
        return ResponseHelper.buildResponse(docCommentsService.like(sequenceNbr));
    }


    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "分页查询文档的评论")
    @RequestMapping(value = "/page", method = RequestMethod.GET)
    public ResponseModel<Page> queryForPage(
            @RequestParam(value = "docSeq") Long docSeq,
            @RequestParam(value = "current") int current,
            @RequestParam(value = "size") int size) {
        Page page = new Page();
        page.setCurrent(current);
        page.setSize(size);
        return ResponseHelper.buildResponse(docCommentsService.queryDocCommentsPage(page, RequestContext.getAgencyCode(), docSeq));
    }

}
