package com.yeejoin.amos.maintenance.business.controller;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletResponse;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.scheduling.annotation.Async;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import com.yeejoin.amos.maintenance.business.constants.XJConstant;
import com.yeejoin.amos.maintenance.business.dto.CheckDto;
import com.yeejoin.amos.maintenance.business.param.CheckInfoPageParam;
import com.yeejoin.amos.maintenance.business.param.CheckRecordParam;
import com.yeejoin.amos.maintenance.business.param.CheckStatisticalParam;
import com.yeejoin.amos.maintenance.business.service.intfc.ICheckService;
import com.yeejoin.amos.maintenance.business.service.intfc.IPlanTaskService;
import com.yeejoin.amos.maintenance.business.service.intfc.ISafety3DDataSendService;
import com.yeejoin.amos.maintenance.business.util.CheckPageParamUtil;
import com.yeejoin.amos.maintenance.business.util.CheckParamUtil;
import com.yeejoin.amos.maintenance.business.util.CommonResponse;
import com.yeejoin.amos.maintenance.business.util.CommonResponseUtil;
import com.yeejoin.amos.maintenance.business.util.DaoCriteria;
import com.yeejoin.amos.maintenance.business.util.FileHelper;
import com.yeejoin.amos.maintenance.business.util.Toke;
import com.yeejoin.amos.maintenance.business.util.ToolUtils;
import com.yeejoin.amos.maintenance.business.vo.CheckAnalysisVo;
import com.yeejoin.amos.maintenance.business.vo.CheckInfoVo;
import com.yeejoin.amos.maintenance.common.enums.PlanTaskFinishStatusEnum;
import com.yeejoin.amos.maintenance.core.async.AsyncTask;
import com.yeejoin.amos.maintenance.core.common.request.CommonPageable;
import com.yeejoin.amos.maintenance.core.common.request.CommonRequest;
import com.yeejoin.amos.maintenance.core.common.response.AppPointCheckRespone;
import com.yeejoin.amos.maintenance.core.common.response.GraphInitDataResponse;
import com.yeejoin.amos.maintenance.core.framework.Permission;
import com.yeejoin.amos.maintenance.core.util.StringUtil;
import com.yeejoin.amos.maintenance.dao.entity.PlanTask;
import com.yeejoin.amos.maintenance.mqtt.WebMqttComponent;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

@RestController
@RequestMapping(value = "/api/check")
@Api(tags = "巡检记录api")
public class CheckController extends AbstractBaseController {
    private final Logger log = LoggerFactory.getLogger(CheckController.class);
    @Autowired
    private ICheckService checkService;

    @Autowired
    private AsyncTask asyncTask;

    @Autowired
    private IPlanTaskService planTaskService;

    @Autowired
    private ISafety3DDataSendService is;

    @Value("${windows.img.path}")
    private String winImgPath;

    @Value("${linux.img.path}")
    private String linuxImgPath;

//    @Value("${file.ip}")
//    private String fileIp;
//
//    @Value("${file.port}")
//    private String filePort;
    @Value("${file.url}")
    private String fileUrl;
    
    @Value("${amosRefresh.patrol.topic}")
    private String patrolTopic;
    @Autowired
    private WebMqttComponent webMqttComponent;

    /**
     * 巡检计划查询
     *
     * @param
     * @param
     * @return
     */
    @Permission
    @ApiOperation(value = "巡检记录查询", notes = "巡检记录查询")
    @RequestMapping(value = "/list", produces = "application/json;charset=UTF-8", method = RequestMethod.POST)
    public CommonResponse qryCheckInfoPage(
            @ApiParam(value = "查询条件", required = false) @RequestBody(required = false) List<CommonRequest> queryRequests,
            @ApiParam(value = "分页参数", required = true) CommonPageable commonPageable) {
        ReginParams reginParams = getSelectedOrgInfo();
        String orgCode = getLoginOrgCode(reginParams);
        boolean hasOrgCode = Boolean.TRUE;
        String roleTypeName = getRoleTypeName(reginParams);
        if (0 < queryRequests.size()) {
            for (CommonRequest x : queryRequests) {
                if ("orgCode".equals(x.getName()) && BooleanUtils.isFalse(Boolean.valueOf(x.getValue().toString()))) {
                    hasOrgCode = Boolean.FALSE;
                }
            }
            ;
        }
        HashMap<String, Object> paramMap;
        if (hasOrgCode) {
            paramMap = buildMybatisCriterias(orgCode, roleTypeName);
        } else {
            paramMap = buildMybatisCriterias(null, null);
        }
        CheckInfoPageParam param = CheckPageParamUtil.fillCheckInfoParam(queryRequests, commonPageable, paramMap);
        if (ObjectUtils.isEmpty(param.getOrderBy())) {
            param.setOrderBy("checkDate desc");
        }
        Page<CheckInfoVo> list = checkService.getCheckInfo(getToken(), getProduct(), getAppKey(), param);
        return CommonResponseUtil.success(list);
    }

    @Permission
    @ApiOperation(value = "导出巡检记录", notes = "导出巡检记录")
    @PostMapping(value = "/export", produces = "application/vnd.ms-excel;charset=UTF-8")
    public void exportCheck(
            @ApiParam(value = "查询条件", required = false) @RequestBody(required = false) List<CommonRequest> queryRequests,
            HttpServletResponse response) {
        ReginParams reginParams = getSelectedOrgInfo();
        String orgCode = getLoginOrgCode(reginParams);
        String roleTypeName = getRoleTypeName(reginParams);
        boolean hasOrgCode = Boolean.TRUE;
        if (0 < queryRequests.size()) {
            for (CommonRequest x : queryRequests) {
                if ("orgCode".equals(x.getName()) && BooleanUtils.isFalse(Boolean.valueOf(x.getValue().toString()))) {
                    hasOrgCode = Boolean.FALSE;
                }
            }
        }
        HashMap<String, Object> paramMap;
        if (hasOrgCode) {
            paramMap = buildMybatisCriterias(orgCode, roleTypeName);
        } else {
            paramMap = buildMybatisCriterias(null, null);
        }
        CheckInfoPageParam param = CheckPageParamUtil.fillCheckInfoParam(queryRequests, null, paramMap);
        param.setPageSize(-1);
        param.setOrderBy("checkDate DESC");
        List<CheckInfoVo> list = checkService.getCheckInfoList(getToken(), getProduct(), getAppKey(), param);
        String fileName = "巡检记录" + new Date().getTime();
        FileHelper.exportExcel(list, "维保记录", "维保记录", CheckInfoVo.class, fileName + ".xls", response);
//        List<Long> idsList = checkService.getAllIdsByConditions(param);
//        if (!CollectionUtils.isEmpty(idsList)) {
//            List<CheckInfoVo> list = checkService.getSelectedCheckInfoList(idsList.toArray(new Long[idsList.size()]));
//            this.userDeptNameConver(list);
//            String fileName = "巡检记录" + System.currentTimeMillis();
//            FileHelper.exportExcel(list, "巡检记录", "巡检记录", CheckInfoVo.class, fileName + ".xls", response);
//        }

    }

    @Permission
    @ApiOperation(value = "导出巡检记录", notes = "导出巡检记录")
    @RequestMapping(value = "/exportSelectRecord", method = RequestMethod.GET)
    public void exportSelectCheckRecord(
            @ApiParam(value = "查询条件", required = false) @RequestParam(required = false) Long[] ids,
            HttpServletResponse response) {
        List<CheckInfoVo> list = checkService.getSelectedCheckInfoList(getToken(), getProduct(), getAppKey(), ids);
        String fileName = "巡检记录" + new Date().getTime();
        FileHelper.exportExcel(list, "巡检记录", "巡检记录", CheckInfoVo.class, fileName + ".xls", response);
    }

    @Permission
    @ApiOperation(value = "导出巡检记录图片", notes = "导出巡检记录图片")
    @RequestMapping(value = "/exportImgs", method = RequestMethod.POST)
    public void exportCheckImgs(
            @ApiParam(value = "查询条件", required = false) @RequestBody(required = false) List<CommonRequest> queryRequests,
            HttpServletResponse response) {
        ReginParams reginParams = getSelectedOrgInfo();
        String orgCode = getLoginOrgCode(reginParams);
        String roleTypeName = getRoleTypeName(reginParams);
        boolean hasOrgCode = Boolean.TRUE;
        if (0 < queryRequests.size()) {
            for (CommonRequest x : queryRequests) {
                if ("orgCode".equals(x.getName()) && BooleanUtils.isFalse(Boolean.valueOf(x.getValue().toString()))) {
                    hasOrgCode = Boolean.FALSE;
                }
            }
            ;
        }
        HashMap<String, Object> paramMap;
        if (hasOrgCode) {
            paramMap = buildMybatisCriterias(orgCode, roleTypeName);
        } else {
            paramMap = buildMybatisCriterias(null, null);
        }
        CheckInfoPageParam param = CheckPageParamUtil.fillCheckInfoParam(queryRequests, null, paramMap);
        List<Map<String, Object>> list = checkService.getCheckInfoImgsList(param);
        String fileName = "巡检记录图片" + new Date().getTime() + ".zip";
//        String rootPath = "http://" + fileIp + ":" + filePort + "/";
        for (Map<String, Object> map : list) {
            map.put("photoData", fileUrl + map.get("photoData").toString());
        }
        FileHelper.exportZip(list, fileName, response);
    }

    @Permission
    @ApiOperation(value = "导出巡检记录图片", notes = "导出巡检记录图片")
    @RequestMapping(value = "/exportImgsByIds", method = RequestMethod.GET)
    public void exportCheckImgs(@ApiParam(value = "查询条件", required = false) @RequestParam(required = false) Long[] ids,
                                HttpServletResponse response) {
        List<Map<String, Object>> list = checkService.getCheckInfoImgsList(ids);
        String fileName = "巡检记录图片" + new Date().getTime() + ".zip";
//        String rootPath = "http://" + fileIp + ":" + filePort + "/";
        for (Map<String, Object> map : list) {
            map.put("photoData", fileUrl + map.get("photoData").toString());
        }
        FileHelper.exportZip(list, fileName, response);
    }

    @Permission
    @ApiOperation(value = "保存巡检记录<font color='blue'>手机app</font>", notes = "保存巡检记录<font color='blue'>手机app</font>")
    @RequestMapping(value = "/saveRecord", produces = "application/json;charset=UTF-8", method = RequestMethod.POST)
    public CommonResponse saveCheckRecord(
            @ApiParam(value = "检查信息", required = false) @RequestBody(required = true) CheckRecordParam requestParam) {
        Toke token = new Toke();
        token.setProduct(request.getHeader("product"));
        token.setToke(request.getHeader("X-Access-Token"));
        token.setAppKey(request.getHeader("appKey"));
        int statu = -1;
        PlanTask planTask = null;
        if (requestParam.getPlanTaskId() != null && requestParam.getPlanTaskId() != 0) {
            planTask = planTaskService.selectPlanTaskStatus(requestParam.getPlanTaskId());
        }
        AgencyUserModel user = getUserInfo();
        String userId = user.getUserId();
        String realName = user.getRealName();
        requestParam.setIsOffline(requestParam.getIsOffline() == null ? false : requestParam.getIsOffline());
        try {
            if (planTask != null) {
                if (!ToolUtils.transBeanList(planTask.getUserId()).contains(userId.toString())) {
                    return CommonResponseUtil.failure("无权执行该任务");
                }

                statu = planTask.getFinishStatus();
                if (!requestParam.getIsOffline() && statu == PlanTaskFinishStatusEnum.OVERTIME.getValue()) {
                    return CommonResponseUtil.failure("任务已超时，上传失败！");
                } else if (statu == PlanTaskFinishStatusEnum.FINISHED.getValue()) {
                    return CommonResponseUtil.failure("任务已完成！");
                }

                Date checkTime = requestParam.getIsOffline() ? com.yeejoin.amos.maintenance.core.util.DateUtil.getLongDate(requestParam.getCheckTime()) : new Date();
                Date beginTime = com.yeejoin.amos.maintenance.core.util.DateUtil.getLongDate(planTask.getBeginTime());
                Date endTime = com.yeejoin.amos.maintenance.core.util.DateUtil.getLongDate(planTask.getEndTime());
                int beginCompareTo = checkTime.compareTo(beginTime);
                int endCompareTo = checkTime.compareTo(endTime);
                if (beginCompareTo == -1 || endCompareTo == 1) {
                    return CommonResponseUtil.failure("请在计划时间内完成任务！");
                }
            }
            int count = checkService.checkHasRecord(requestParam);
            if (count < 1 || requestParam.getPlanTaskId() < 1) {
                ReginParams reginParams = getSelectedOrgInfo();
                String orgCode = getLoginOrgCode(reginParams);
                String departmentId = getDepartmentId(reginParams);
                requestParam.setOrgCode(orgCode);
                requestParam.setUserId(getUserId());
                requestParam.setCheckDepartmentId(departmentId);
                CheckDto checkDto = checkService.saveCheckRecord(requestParam, getUserInfo(), reginParams.getDepartment(), token);
                if (com.yeejoin.amos.maintenance.core.util.StringUtil.isNotEmpty(checkDto)) {
                    asyncTaskf(checkDto.getCheckId());
                }
                is.pointCheckInfoPushToB(checkDto.getCheckId());
                //数字换流站页面刷新
                try {
                    webMqttComponent.publish(patrolTopic, "");
                } catch (Exception e) {
                    log.error("数字换流站页面推送失败-----------" + e.getMessage());
                }
                return CommonResponseUtil.success(checkDto);
            } else {
                return CommonResponseUtil.success("无需重新巡检");
            }
        } catch (Exception e) {
            e.printStackTrace();
            // TODO Auto-generated catch block
            log.error(e.getMessage());
            return CommonResponseUtil.failure("数据提交失败");
        }
    }

    @Async
    public void asyncTaskf(Long id) {

        try {
            asyncTask.pushCheckInfoTo3D(id);
            asyncTask.pushCheckMessage(id);
        } catch (InterruptedException e) {
            e.printStackTrace();
        }

    }

    @Permission
    @ApiOperation(value = "删除巡检记录", notes = "删除巡检记录")
    @RequestMapping(value = "/testPush", produces = "application/json;charset=UTF-8", method = RequestMethod.POST)
    public CommonResponse deleteCheckById(@ApiParam(value = "巡检计划ID", required = true) @RequestBody Long id) {
        try {
            asyncTask.pushCheckMessage(id);
            return CommonResponseUtil.success();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return CommonResponseUtil.failure("删除巡检记录失败");
        }
    }


    /**
     * 巡检计划删除（支持批量）
     *
     * @param
     * @return
     */
    @Permission
    @ApiOperation(value = "删除巡检记录", notes = "删除巡检记录")
    @RequestMapping(value = "/deleteCheckById", produces = "application/json;charset=UTF-8", method = RequestMethod.POST)
    public CommonResponse deleteCheckById(@ApiParam(value = "巡检计划ID", required = true) @RequestBody List<Long> ids) {
        try {
            checkService.delCheckById(ids);
            return CommonResponseUtil.success();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return CommonResponseUtil.failure("删除巡检记录失败");
        }
    }


    /**
     * 根据检查项ID获取所有不合格检查项
     *
     * @param
     * @return
     */
    @Permission
    @ApiOperation(value = "据检查项ID获取所有不合格检查项<font color='blue'>手机app</font>", notes = "据检查项ID获取所有不合格检查项<font color='blue'>手机app</font>")
    @RequestMapping(value = "/queryUnqualifiedInputItem", produces = "application/json;charset=UTF-8", method = RequestMethod.GET)
    public CommonResponse queryUnqualifiedInputItem(@RequestParam(required = true) int checkId) {
        try {
            List<Map> list = checkService.queryUnqualifiedInputItem(checkId);
            return CommonResponseUtil.success(list);
        } catch (Exception e) {
            return CommonResponseUtil.failure(e.getMessage());
        }

    }

    @Permission
    @ApiOperation(value = "获取巡检计划巡检点(已完成或漏检的巡检点)详情信息<font color='blue'>手机app</font>", notes = "获取巡检计划巡检点(已完成或漏检的巡检点)详情信息<font color='blue'>手机app</font>")
    @RequestMapping(value = "/queryCheckPointDetail", produces = "application/json;charset=UTF-8", method = RequestMethod.GET)
    public CommonResponse queryCheckPointDetail(@RequestParam long checkId) {
        try {
            AppPointCheckRespone pointCheckRespone = checkService.queryCheckPointDetail(getToken(), getProduct(), getAppKey(), checkId);
            return CommonResponseUtil.success(pointCheckRespone);
        } catch (Exception e) {
            e.printStackTrace();
            return CommonResponseUtil.failure(e.getMessage());
        }

    }

    @Permission
    @ApiOperation(value = "获取巡检计划巡检点(已完成或漏检的巡检点)详情信息<font color='blue'>手机app</font>", notes = "获取巡检计划巡检点(已完成或漏检的巡检点)详情信息<font color='blue'>手机app</font>")
    @RequestMapping(value = "/v2/queryCheckPointDetail", produces = "application/json;charset=UTF-8", method = RequestMethod.GET)
    public CommonResponse queryCheckPointDetailInVersion2(@RequestParam long checkId) {
        try {
            AppPointCheckRespone pointCheckRespone = checkService.queryCheckPointDetailInVersion2(getToken(), getProduct(), getAppKey(), checkId);
            return CommonResponseUtil.success(pointCheckRespone);
        } catch (Exception e) {
            e.printStackTrace();
            return CommonResponseUtil.failure(e.getMessage());
        }

    }

    /**
     * 获取巡检日历数据
     *
     * @param queryRequests
     * @return
     */
    @Permission
    @ApiOperation(value = "获取巡检日历数据<font color='blue'>手机app</font>", notes = "获取巡检日历数据<font color='blue'>手机app</font>")
    @PostMapping(value = "/checkCalendar", produces = "application/json;charset=UTF-8")
    public CommonResponse checkCalendar(
            @ApiParam(value = "查询条件", required = false) @RequestBody(required = false) List<CommonRequest> queryRequests) {
        try {
            ReginParams reginParams = getSelectedOrgInfo();
            String loginOrgCode = getLoginOrgCode(reginParams);
            String roleTypeName = getRoleTypeName(reginParams);
            List<DaoCriteria> daoCriterias = buildDaoCriterias(queryRequests, true, loginOrgCode, roleTypeName);


            Map<String, Object> map = checkService.checkCalendar(CheckParamUtil.checkCalendar(daoCriterias));
            return CommonResponseUtil.success(map);
        } catch (Exception e) {
            e.printStackTrace();
            return CommonResponseUtil.failure(e.getMessage());
        }

    }

    @Permission
    @ApiOperation(value = "获取巡检点巡检记录列表信息<font color='blue'>手机app</font>", notes = "获取巡检点巡检记录列表信息<font color='blue'>手机app</font>")
    @RequestMapping(value = "/queryCheckRecord", produces = "application/json;charset=UTF-8", method = RequestMethod.POST)
    public CommonResponse queryRecordByPointId(
            @ApiParam(value = "查询条件", required = false) @RequestBody(required = false) List<CommonRequest> queryRequests) {
        ReginParams reginParams = getSelectedOrgInfo();
        String loginOrgCode = getLoginOrgCode(reginParams);
        String roleTypeName = getRoleTypeName(reginParams);
        String departmentId = getDepartmentId(reginParams);
        HashMap<String, Object> req = CheckPageParamUtil.fillInfo(queryRequests);
        if (XJConstant.ROLE_NAME_ADMIN.equals(roleTypeName.toUpperCase())
                || XJConstant.ROLE_NAME_SUPERADMIN.equals(roleTypeName.toUpperCase())) {
            req.put("orgCode", loginOrgCode);
        } else if (XJConstant.ROLE_NAME_DEPTADMIN.equals(roleTypeName.toUpperCase())) {
            req.put("departmentId", departmentId);
        } else {
            if (StringUtil.isNotEmpty(req.get("userId")) && req.get("userId") == null) {
                req.put("userId", getUserId());
            }
        }
        Map<String, Object> map = checkService.queryRecordByPointId(req);
        return CommonResponseUtil.success(map);
    }

    @Permission
    @ApiOperation(value = "获取巡检记录详情信息<font color='blue'>手机app</font>", notes = "获取巡检记录详情信息<font color='blue'>手机app</font>")
    @RequestMapping(value = "/queryCheckDetail", produces = "application/json;charset=UTF-8", method = RequestMethod.GET)
    public CommonResponse queryRecordById(@RequestParam(required = true) int checkId) {
        try {
            Map<String, Object> map = checkService.queryRecordById(checkId);
            return CommonResponseUtil.success(map);
        } catch (Exception e) {
            e.printStackTrace();
            return CommonResponseUtil.failure(e.getMessage());
        }
    }

    /**
     * 根据巡检记录ID获取巡检记录详情
     *
     * @param checkId
     * @return
     */
    @Permission
    @ApiOperation(value = "根据巡检记录ID获取巡检记录详情", notes = "根据巡检记录ID获取巡检记录详情")
    @RequestMapping(value = "/queryCheckInfo", produces = "application/json;charset=UTF-8", method = RequestMethod.GET)
    public CommonResponse printTaskDetail(@ApiParam(value = "巡检记录ID") @RequestParam(required = true) int checkId) {
        Map<String, Object> map = checkService.queryRecordById(checkId);
        String xml = ToolUtils.map2Xml(map, "CheckInfo");
        if (ObjectUtils.isEmpty(xml)) {
            return CommonResponseUtil.failure();
        }
        InputStream inputStream = new ByteArrayInputStream(xml.getBytes());
        ;
        Source source = new StreamSource(inputStream);
        try {
            FileInputStream fis1 = new FileInputStream(
                    this.getClass().getResource("/").getPath() + "temp/checkTemplate.xsl");
            Source template = new StreamSource(fis1);
            Date date = new Date();
            String path = request.getSession().getServletContext().getRealPath("/");
            String dir = path.substring(0, path.indexOf(File.separator) + 1) + "check";
            String html = path.substring(0, path.indexOf(File.separator) + 1) + "check" + File.separator + "task_"
                    + date.getTime() + ".html";
            File dirFile = new File(dir);
            if (!dirFile.exists()) {
                dirFile.mkdirs();
            }

            Result result = new StreamResult(html);
            Transformer transformer = TransformerFactory.newInstance().newTransformer(template);

            transformer.transform(source, result);

            File htmlFile = new File(html);
            FileInputStream fis = new FileInputStream(htmlFile);
            String data = IOUtils.toString(fis, "utf-8");
            fis.close();
            if (htmlFile.exists()) {
                htmlFile.delete();
            }
            return new CommonResponse(SUCCESS, data, "查询成功");
        } catch (TransformerException | IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    /**
     * 获取巡检点，巡检线路初始数据
     *
     * @return
     */
    //@Authorization(ingore=true)
    @Permission
    @ApiOperation(value = "获取巡检点初始数据(<font color='blue'>release</font>)", notes = "获取巡检点初始数据")
    @RequestMapping(value = "/viewModule/initData", method = RequestMethod.GET, produces = "application/json;charset=UTF-8")
    public CommonResponse getViewModuleInitData() {
        try {
            GraphInitDataResponse graphInitDataResponse = checkService.getViewModuleInitData();
            return CommonResponseUtil.success(graphInitDataResponse);
        } catch (Exception e) {
            e.printStackTrace();
            log.error(e.getMessage(), e);
            return CommonResponseUtil.failure();
        }
    }

    @Permission
    @ApiOperation(value = "巡检情况统计分析", notes = "巡检情况统计分析")
    @RequestMapping(value = "/statisticalAnalysis", method = RequestMethod.POST, produces = "application/json;charset=UTF-8")
    public CommonResponse getCheckStatisticalAnalysis(
            @ApiParam(value = "查询条件", required = false) @RequestBody(required = false) CheckStatisticalParam queryRequests) {
        ReginParams reginParams = getSelectedOrgInfo();
        String loginOrgCode = getLoginOrgCode(reginParams);
        queryRequests.setOrgCode(loginOrgCode);
        List<CheckAnalysisVo> list = checkService.getCheckStatisticalAnalysis(getToken(), getProduct(), getAppKey(), queryRequests);
        return CommonResponseUtil.success(list);
    }

    @Permission
    @ApiOperation(value = "导出巡检情况统计分析", notes = "导出巡检情况统计分析")
    @RequestMapping(value = "/exportStatisticalAnalysis", method = RequestMethod.POST, produces = "application/vnd.ms-excel;charset=UTF-8")
    public void exportStatisticalAnalysis(
            @ApiParam(value = "查询条件", required = false) @RequestBody(required = false) CheckStatisticalParam queryRequests,
            HttpServletResponse response) {
        String userId = getUserId();
        ReginParams reginParams = getSelectedOrgInfo();
        String loginOrgCode = getLoginOrgCode(reginParams);
        queryRequests.setOrgCode(loginOrgCode);
        List<CheckAnalysisVo> list = checkService.getCheckStatisticalAnalysis(getToken(), getProduct(), getAppKey(), queryRequests);
        String fileName = "巡检记录" + new Date().getTime();
        FileHelper.exportExcel(list, "巡检情况统计分析\"", "巡检情况统计分析\"", CheckAnalysisVo.class, fileName + ".xls", response);
    }


    /**
     * 根据检查项ID和检查输入项ID查询图片， 如果输入项ID位0时，查询巡检现场照片， 如果不为0查询检查项照片
     *
     * @param checkId
     * @param checkInputId
     * @return
     */
    @Permission
    @ApiOperation(value = "获取检查项照片URL(<font color='blue'>release</font>)", notes = "获取检查项照片URL")
    @RequestMapping(value = "/getCheckPic", method = RequestMethod.GET, produces = "application/json;charset=UTF-8")
    public CommonResponse getCheckPhotosByCheckAndInputId(
            @ApiParam(value = "巡检记录ID") @RequestParam(required = true) int checkId,
            @ApiParam(value = "检查输入项ID") @RequestParam(required = false) int checkInputId,
            @ApiParam(value = "分类ID") @RequestParam(required = false) int classifyId) {
        try {
            List<String> list = checkService.getCheckPhotosByCheckAndInputId(checkId, checkInputId, classifyId);
            return CommonResponseUtil.success(list);
        } catch (Exception e) {
            return CommonResponseUtil.failure(e.getMessage());
        }
    }

    @Permission
    @ApiOperation(value = "查询最近一条维保记录", notes = "不包括漏检")
    @GetMapping(value = "/{relationId}/last-check")
    public CommonResponse obtainLastCheckRecord(
            @ApiParam(value = "源ids,逗号分隔", required = true) @PathVariable String... relationId) {
        return CommonResponseUtil.success(checkService.obtainLastCheckRecord(relationId));
    }
}
