package com.yeejoin.amos.maintenance.business.controller;

import java.util.List;

import com.yeejoin.amos.maintenance.business.dao.repository.IConfigDao;
import com.yeejoin.amos.maintenance.business.util.CommonResponse;
import com.yeejoin.amos.maintenance.business.util.CommonResponseUtil;
import com.yeejoin.amos.maintenance.core.framework.Permission;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import com.yeejoin.amos.maintenance.dao.entity.Config;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;


/**
 * 获取主题信息
 * 
 * @author 
 *
 */
@RestController
@RequestMapping(value = "/api/config")
@Api(tags="配置接口api")
public class ConfigController extends AbstractBaseController{
	private final Logger log = LoggerFactory.getLogger(ConfigController.class);
	
	
	@Autowired
	private IConfigDao configDao ;
	/**
	 * <pre>
	 * 获取配置接口信息
	 * </pre>
	 * 
	 * 
	 * @return
	 */
	//@Authorization(ingore = true)
	@Permission
	@ApiOperation(value = "获取配置接口信息", notes = " 获取配置接口信息")
	@RequestMapping(value = "/getConfigsInfo", produces = "application/json;charset=UTF-8", method = RequestMethod.GET)
	public CommonResponse getConfigsInfo() {
		List<Config> configs = configDao.findAll();
		return CommonResponseUtil.success(configs);
	}
	

}
