package com.yeejoin.amos.patrol.business.service.intfc;


import java.util.List;

import org.springframework.data.domain.Page;

import com.yeejoin.amos.patrol.business.param.MsgInfoPageParam;
import com.yeejoin.amos.patrol.business.param.NoticePublishParam;
import com.yeejoin.amos.patrol.business.vo.MsgVo;
import com.yeejoin.amos.patrol.dao.entity.Check;
import com.yeejoin.amos.patrol.dao.entity.Msg;
import com.yeejoin.amos.patrol.dao.entity.PlanTask;
import com.yeejoin.amos.patrol.dao.entity.Task;

public interface IMessageService {
	
	/**
	 * 巡检消息推送
	 * @param check
	 */
	public void pushCheckMessage(String toke,String product,String appKey,Long checkId);
	
	/**
	 * 任务消息推送
	 * @param task 任务
	 */
	public void pushTaskMessage(String toke,String product,String appKey,Task task);
	
	/**
	 * 计划消息推送
	 * @param planTask
	 * @param jobType
	 */
	public void pushPlanTaskMessage(String toke,String product,String appKey,PlanTask planTask,String jobType);

	
	Page<MsgVo> queryMsgInfoList(MsgInfoPageParam param);

	/**
	 * 发布通知消息
	 * 
	 * @param msg
	 */
	public List<Msg> publishNotice(String toke,String product,String appKey,NoticePublishParam msg);
	
	/**
	 * 消息公告推送
	 * @param msg
	 */
	public Msg pushMsg(String toke,String product,String appKey,Msg msg);

}
