package com.yeejoin.amos.boot.module.tzs.biz.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.entity.DataDictionary;
import com.yeejoin.amos.boot.biz.common.service.impl.DataDictionaryServiceImpl;
import com.yeejoin.amos.boot.module.tzs.api.dto.DispatchPaperFormDto;
import com.yeejoin.amos.boot.module.tzs.api.dto.DispatchTaskDto;
import com.yeejoin.amos.boot.module.tzs.api.dto.RescueProcessDto;
import com.yeejoin.amos.boot.module.tzs.api.entity.AlertFormValue;
import com.yeejoin.amos.boot.module.tzs.api.entity.DispatchPaper;
import com.yeejoin.amos.boot.module.tzs.api.entity.DispatchTask;
import com.yeejoin.amos.boot.module.tzs.api.entity.MaintenanceUnit;
import com.yeejoin.amos.boot.module.tzs.api.entity.RescueProcess;
import com.yeejoin.amos.boot.module.tzs.api.entity.RescueStation;
import com.yeejoin.amos.boot.module.tzs.api.entity.UseUnit;
import com.yeejoin.amos.boot.module.tzs.api.enums.DispatchPaperEnums;
import com.yeejoin.amos.boot.module.tzs.api.mapper.RescueProcessMapper;
import com.yeejoin.amos.boot.module.tzs.api.service.IRescueProcessService;
import com.yeejoin.amos.boot.module.tzs.biz.utils.BeanDtoVoUtils;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.foundation.context.RequestContext;
import org.typroject.tyboot.core.foundation.utils.Bean;
import org.typroject.tyboot.core.rdbms.service.BaseService;
import org.typroject.tyboot.core.restful.exception.instance.BadRequest;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;

import java.util.Date;
import java.util.List;

/**
 * 救援过程表服务实现类
 *
 * @author system_generator
 * @date 2021-08-03
 */
@Service
public class RescueProcessServiceImpl extends BaseService<RescueProcessDto,RescueProcess,RescueProcessMapper> implements IRescueProcessService {

    @Autowired
    DispatchPaperServiceImpl dispatchPaperServiceImpl;


    @Autowired
    private DataDictionaryServiceImpl iDataDictionaryService;

    @Autowired
    DispatchTaskServiceImpl dispatchTaskServiceImpl;

    @Autowired
    private AlertFormValueServiceImpl iAlertFormValueService;

    /**
     * 分页查询
     */
    public Page<RescueProcessDto> queryForRescueProcessPage(Page<RescueProcessDto> page)   {
        return this.queryForPage(page, null, false);
    }

    /**
     * 列表查询 示例
     */
    public List<RescueProcessDto> queryForRescueProcessList()   {
        return this.queryForList("" , false);
    }

    @Override
    public RescueProcessDto getProcessByAlertId(Long alertId) {
        // 先通过id 查找过程表
        RescueProcessDto rescueProcessDto = new RescueProcessDto();
        QueryWrapper<RescueProcess> templateQueryWrapper = new QueryWrapper<>();
        templateQueryWrapper.eq("alert_id",alertId);
        RescueProcess rescueProcess = this.getOne(templateQueryWrapper);
        if(rescueProcess != null) {
            return Bean.toModel(rescueProcess, rescueProcessDto);
        } else {
            rescueProcess = new RescueProcess();
            rescueProcess.setAlertId(alertId);
            this.save(rescueProcess);
            return Bean.toModel(rescueProcess, rescueProcessDto);
        }
    }

    @Override
    public Boolean updateByAlertId(RescueProcessDto rescueProcessDto, AgencyUserModel sendUser) {
        QueryWrapper<RescueProcess> templateQueryWrapper = new QueryWrapper<>();
        templateQueryWrapper.eq("alert_id", rescueProcessDto.getAlertId());
        RescueProcess rescueProcess = this.getOne(templateQueryWrapper);
        if (rescueProcess != null)
            throw new BadRequest("救援过程信息未找到");
        if (rescueProcessDto.getDispatchByUser()) { // 手动更新了派遣信息为三级派遣
            // 判断是否存在派遣单 不存在先创建派遣单
            DispatchPaperFormDto dispatchPaperDto = dispatchPaperServiceImpl.selectDispatchPaperDtoByAlertId(rescueProcessDto.getAlertId());
            if (dispatchPaperDto == null || dispatchPaperDto.getDispatchPaper() == null) {
                QueryWrapper<DataDictionary> queryWrapper = new QueryWrapper<>();
                queryWrapper.eq("type", "JQLX").eq("name", "困人救援");
                DataDictionary alertCode = iDataDictionaryService.getOne(queryWrapper);
                dispatchPaperDto = dispatchPaperServiceImpl.createDispatchPaper(rescueProcessDto.getAlertId(), alertCode.getCode(), sendUser);
            }

            DispatchPaper dispatchPaper = dispatchPaperDto.getDispatchPaper();
            List<AlertFormValue> dynamicFormAlert = dispatchPaperDto.getDynamicFormAlert();
            // 创建派遣单
            DispatchTaskDto dispatchTaskDto = new DispatchTaskDto();
            dispatchTaskDto.setDispatchTime(rescueProcessDto.getDispatchTime());
            dispatchTaskDto.setOrgTypeCode(DispatchPaperEnums.getEnum("levelThreeUnit").getCode());
            dispatchTaskDto.setAlertId(rescueProcessDto.getAlertId());
            dispatchTaskDto.setResponseOrgName("119");
            dispatchTaskDto.setResponseUserName("119");
            DispatchTask dispatchTask = BeanDtoVoUtils.convert(dispatchTaskDto, DispatchTask.class);
            dispatchTask.setPaperId(dispatchPaperDto.getSequenceNbr());
            Boolean flag = dispatchTaskServiceImpl.save(dispatchTask);
            if (flag) { // 创建好派遣任务单以后根据任务单类型修改派遣单信息
                if (dispatchPaper.getRepairOrgId() != null) { // 已经派遣过调派
                    throw new BadRequest("已经派遣过其他力量调派");
                } else {
                    dispatchPaper.setRepairOrgId(-1l);
                    dispatchPaper.setRepairOrgCreditCode("119");
                    dispatchPaper.setRepairOrgTaskId(dispatchTask.getSequenceNbr());
                    // 修改动态字段
                    dynamicFormAlert.stream().forEach(alertFormValue -> {
                        if (alertFormValue.getFieldCode().equals("dispatch_status")) {
                            alertFormValue.setFieldValue("已派遣");
                            alertFormValue.setFieldValueCode("hasDispatched");
                        } else if (alertFormValue.getFieldCode().equals("response_level")) {
                            alertFormValue.setFieldValue("三级响应");
                            alertFormValue.setFieldValueCode("levelThreeUnit");
                        }
                    });
                }
                //  保存派遣单
                dispatchPaperServiceImpl.save(dispatchPaper);
                // 保存动态表单数据
                iAlertFormValueService.saveBatch(dynamicFormAlert);
            }
        }
        rescueProcess = BeanDtoVoUtils.convert(rescueProcessDto, RescueProcess.class);
        return this.updateById(rescueProcess);
    }
}