package com.yeejoin.amos.boot.biz.common.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.yeejoin.amos.boot.biz.config.BitTypeHandler;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.apache.ibatis.type.BigDecimalTypeHandler;
import org.apache.ibatis.type.BigIntegerTypeHandler;

import java.io.Serializable;
import java.util.Date;

/**
 * 公共实体类
 *
 * @author DELL
 */
@Data
@ApiModel(value = "BaseEntity",description = "基础实体类")
public class BaseEntity implements Serializable{
	
	private static final long serialVersionUID = 1L;
	@ApiModelProperty(value = "主键",example = "1712049025391267842")
	@TableId(value = "sequence_nbr", type = IdType.ID_WORKER)
	protected Long sequenceNbr;
	@ApiModelProperty(value = "创建日期",example = "2023-10-11 18:20:51")
	@TableField(value = "rec_date", fill = FieldFill.INSERT_UPDATE)
	protected Date recDate;
	@ApiModelProperty(value = "创建人ID",example = "5606165")
	@TableField(value = "rec_user_id", fill = FieldFill.INSERT_UPDATE)
	protected String recUserId;
	@ApiModelProperty(value = "创建人",example = "admin")
	@TableField(value = "rec_user_name", fill = FieldFill.INSERT_UPDATE)
	protected String recUserName;

	/**
	 * 是否删除
	 */
	@ApiModelProperty(value = "是否删除",example = "false")
	@TableField(value = "is_delete",typeHandler = BitTypeHandler.class)
	public Boolean isDelete=false;

}
