package com.yeejoin.amos.boot.module.hygf.api.dto;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.TableField;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

/**
 * @author system_generator
 * @date 2024-12-06
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "IcbcWithholdRecordDto", description = "")
public class IcbcWithholdRecordDto extends BaseDto {
    @ExcelIgnore
    private static final long serialVersionUID = 1L;


    @ExcelIgnore
    protected Long sequenceNbr;
    @ExcelProperty(value = "户主姓名", index = 0)
    @ApiModelProperty(value = "户主姓名")
    private String custName;
    /**
     * 身份证号
     */
    @ExcelProperty(value = "区域公司", index = 1)
    @ApiModelProperty(value = "区域公司")
    private String regionalCompaniesName;
    /**
     * 手机号码
     */
    @ExcelProperty(value = "手机号", index = 2)
    @ApiModelProperty(value = "手机号码")
    private String phone;

    @ExcelProperty(value = "身份证号", index = 3)
    @ApiModelProperty(value = "身份证号")
    private String idCard;

    /**
     * 聚富通电子账户账号
     */
    @ExcelProperty(value = "银行卡号", index = 4)
    @ApiModelProperty(value = "聚富通电子账户账号")
    private String mediumId;

    /**
     * 开户状态, 00-初始，01-开户中，02-开户成功，03-开户失败
     */
    @ExcelIgnore    @ApiModelProperty(value = "开户状态, 00-初始，01-开户中，02-开户成功，03-开户失败")
    private String openAccountStatus;

    /**
     * 协议状态, 0-未生效，1-已生效，2-过期，3-作废，4-待短信确认
     */
    @ExcelIgnore    @ApiModelProperty(value = "协议状态, 0-未生效，1-已生效，2-过期，3-作废，4-待短信确认")
    private String protocolStatus;


    @ExcelProperty(value = "批次号", index = 5)
    @ApiModelProperty(value = "批次号")
    private String batchNo;


    @ExcelProperty(value = "项目编号", index = 6)
    @ApiModelProperty(value = "项目编号")
    private String projectId;

    @ExcelProperty(value = "付款金额(元)", index = 7)
    @ApiModelProperty(value = "付款金额")
    private double paymentAmount;

    @ExcelProperty(value = "代扣状态", index = 8)
    @ApiModelProperty(value = "代扣状态")
    private String withholdStatus;

    @ExcelIgnore
    @ApiModelProperty(value = "上传时间")
    private Date withholdTime;

    @ExcelProperty(value = "缴费时间", index = 9)
    @ApiModelProperty(value = "缴费时间")
    private Date paymentTime;

    @ExcelIgnore
    @ApiModelProperty(value = "缴费开始时间")
    private String paymentStartTime;
    @ExcelIgnore
    @ApiModelProperty(value = "缴费结束时间")
    private String paymentEndTime;

    @ExcelIgnore
    private String outUserId;
    @ExcelIgnore
    private String amosUserId;
    @ExcelIgnore
    private String contentText;
    @ExcelIgnore
    private String show;

    @ExcelIgnore
    private String regionalCompaniesCode;


}
