package com.yeejoin.amos.boot.module.hygf.api.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.handlers.FastjsonTypeHandler;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.Date;
import java.util.List;

/**
 * 并网信息
 *
 * @author system_generator
 * @date 2024-01-12
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName(value ="hygf_on_grid_and_acceptance",autoResultMap = true)
@ApiModel(value = "HygfOnGrid",description ="并网信息")
public class HygfOnGrid extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 并网申请
     */
    @ApiModelProperty(value = "并网申请",example = "[{\"uid\":\"amos-upload-1718704468706-45\",\"name\":\"c697beac6170e3aa7b300a44fef9751.png\",\"url\":\"/upload/jxiop/amos_studio/6702951/E0B1EC278112E95474A272E8E3478C94.png\",\"status\":\"done\"}]")
    @TableField(value ="grid_connection_application",typeHandler = FastjsonTypeHandler.class)
    private List<Object>  gridConnectionApplication;

    /**
     * 并网回执
     */
    @ApiModelProperty(value = "并网回执",example = "[{\"uid\":\"amos-upload-1718704468706-47\",\"name\":\"ff3bb95792ad9aab2a7562640f56387.png\",\"url\":\"/upload/jxiop/amos_studio/6702951/62179B20ABBBCF1FFFBEF328E36828.png\",\"status\":\"done\"}]")
	@TableField(value ="grid_connection_receipt",typeHandler = FastjsonTypeHandler.class)
    private List<Object>  gridConnectionReceipt;

    /**
     * 并网方案
     */
    @ApiModelProperty(value = "并网方案",example = "[{\"uid\":\"amos-upload-1718704468706-49\",\"name\":\"01d5189960473e76aae9cea2e7c3c6b.png\",\"url\":\"/upload/jxiop/amos_studio/6702951/E64563083D0FF1FF375BDEA13E9CD11.png\",\"status\":\"done\"},{\"uid\":\"amos-upload-1718704468706-50\",\"name\":\"ef69465d929b216519f3cb42ee5da8b.png\",\"url\":\"/upload/jxiop/amos_studio/6702951/7FECCAE05CF8C678DB02869C9478FED.png\",\"status\":\"done\"}]")
	@TableField(value ="grid_connection_scheme",typeHandler = FastjsonTypeHandler.class)
    private List<Object>  gridConnectionScheme;

    /**
     * 供电合同
     */
    @ApiModelProperty(value = "供电合同",example = "[{\"uid\":\"0.optumczxo5r\",\"name\":\"4921.jpg\",\"url\":\"/upload/common/7AF1F7FF6D20B3A0DFB919DD2C0CE87.jpg\"}]")
	@TableField(value ="power_supply_contract",typeHandler = FastjsonTypeHandler.class)
    private List<Object>  powerSupplyContract;

    /**
     * 购售合同
     */
    @ApiModelProperty(value = "购售合同",example = "[{\"uid\":\"amos-upload-1718276542534-12\",\"name\":\"发用电合同.pdf\",\"url\":\"/upload/jxiop/amos_studio/6406664/E0FA7C856A991C6FEA89B2F6A2A968.pdf\",\"status\":\"done\"}]")
	@TableField(value ="purchase_sale_contract",typeHandler = FastjsonTypeHandler.class)
    private List<Object>  purchaseSaleContract;

    /**
     * 并网协议
     */
    @ApiModelProperty(value = "并网协议",example = "[{\"uid\":\"amos-upload-1718276542534-14\",\"name\":\"发用电合同.pdf\",\"url\":\"/upload/jxiop/amos_studio/6406664/F2730C3413BD5E97EAA8A637A1D83F2.pdf\",\"status\":\"done\"}]")
	@TableField(value ="grid_connection_protocol",typeHandler = FastjsonTypeHandler.class)
    private List<Object>  gridConnectionProtocol;

    /**
     * 并网合同
     */
    @ApiModelProperty(value = "并网合同",example = "[{\"uid\":\"amos-upload-1718722141999-38\",\"name\":\"发用电合同.pdf\",\"url\":\"/upload/jxiop/amos_studio/6406664/6F27B3267D1B7190253832B4C2BCBD3.pdf\",\"status\":\"done\"}]")
	@TableField(value ="grid_connection_contract",typeHandler = FastjsonTypeHandler.class)
    private List<Object>  gridConnectionContract;

    /**
     * 光e宝
     */
    @ApiModelProperty(value = "光e宝",example = "[{\"uid\":\"amos-upload-1719462431414-41\",\"name\":\"发用电.pdf\",\"url\":\"/upload/jxiop/amos_studio/6406664/4F46FA9F2E4A19378CEB7AA546AFB.pdf\",\"status\":\"done\"}]")
	@TableField(value ="guang_e_bao",typeHandler = FastjsonTypeHandler.class)
    private List<Object>  guangEBao;

    /**
     * 开户行
     */
    @ApiModelProperty(value = "开户行",example = "海口农商银行石山支行")
	@TableField("bank")
    private String bank;

    /**
     * 户名
     */
    @ApiModelProperty(value = "户名",example = "钟保才")
	@TableField("account_name")
    private String accountName;

    /**
     * 账号
     */
    @ApiModelProperty(value = "账号",example = "3436248200000740")
	@TableField("account_number")
    private String accountNumber;

    /**
     * 合同到期时间
     */
    @ApiModelProperty(value = "合同到期时间",example = "2049-06-06")
    @JsonFormat(pattern = "yyyy-MM-dd")
	@TableField("contract_expiration_date")
    private Date contractExpirationDate;

    /**
     * 有效发电开始日
     */
    @ApiModelProperty(value = "有效发电开始日",example = "2024-06-11")
    @JsonFormat(pattern = "yyyy-MM-dd")
	@TableField("effective_power_generation_start_date")
    private Date effectivePowerGenerationStartDate;

    /**
     * 并网箱整体照片
     */
    @ApiModelProperty(value = "并网箱整体照片",example = "[{\"uid\":\"amos-upload-1719408990562-61\",\"name\":\"电箱.jpg\",\"url\":\"/upload/jxiop/amos_studio/6406664/FA626C261EE18B852C520A2D172ACE2.jpg\",\"status\":\"done\"}]")
	@TableField(value ="overall_photo_grid_cage",typeHandler = FastjsonTypeHandler.class)
    private List<Object>  overallPhotoGridCage;

    /**
     * 表箱整体照片
     */
    @ApiModelProperty(value = "表箱整体照片",example = "[{\"uid\":\"amos-upload-1719408990562-63\",\"name\":\"电箱.jpg\",\"url\":\"/upload/jxiop/amos_studio/6406664/9281CC7CC55DCC6488B5193F3B6081.jpg\",\"status\":\"done\"}]")
	@TableField(value ="electric_meter_box",typeHandler = FastjsonTypeHandler.class)
    private List<Object>  electricMeterBox;

    /**
     * 电表照片或视频
     */
    @ApiModelProperty(value = "电表照片或视频",example = "[{\"uid\":\"amos-upload-1719408990562-99\",\"name\":\"电表.jpg\",\"url\":\"/upload/jxiop/amos_studio/6406664/B399377A21604009B9F6697F438A9B7.jpg\",\"status\":\"done\"}]")
	@TableField(value ="electricity_meter",typeHandler = FastjsonTypeHandler.class)
    private List<Object> electricityMeter;

    /**
     * 施工单id
     */
    @ApiModelProperty(value = "施工单id",example = "1804051827063287810")
	@TableField("work_order_id")
    private Long workOrderId;

    /**
     * 施工电站id
     */
    @ApiModelProperty(value = "施工电站id",example = "1804051827105230850")
	@TableField("work_order_power_station_id")
    private Long workOrderPowerStationId;

    /**
     * 农户id
     */
    @ApiModelProperty(value = "农户id",example = "1784414465702260737")
	@TableField("peasant_household_id")
    private Long peasantHouseholdId;
    
    @ApiModelProperty(value = "并网时间",example = "2024-07-05 19:16:28")
    @TableField("grid_connection_time")
    private Date gridConnectionTime;
    
    @ApiModelProperty(value = "类型",example = "zx")
    @TableField(exist = false)
    private String type;


    /**
     * 片区整改单
     */
    @ApiModelProperty(value = "片区整改单")
    @TableField(exist = false)
    private List<HygfRectificationOrder>  areaOrders;
    /**
     * 工程整改单
     */
    @ApiModelProperty(value = "工程整改单")
    @TableField(exist = false)
    private List<HygfRectificationOrder>  engineeringOrders;
    /**
     * 设计整改单
     */
    @ApiModelProperty(value = "设计整改单")
    @TableField(exist = false)
    private List<HygfRectificationOrder>  designOrders;
}
