package com.yeejoin.amos.boot.module.hygf.biz.controller;

import com.yeejoin.amos.boot.module.hygf.api.config.UserLimits;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.RequestMapping;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Api;
import org.springframework.web.bind.annotation.RestController;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import java.util.List;
import java.util.Map;

import com.yeejoin.amos.boot.module.hygf.biz.service.impl.IcbcWithholdRecordServiceImpl;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;
import org.springframework.beans.factory.annotation.Autowired;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.hygf.api.dto.IcbcWithholdRecordDto;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.foundation.enumeration.UserType;

/**
 * 
 *
 * @author system_generator
 * @date 2024-12-06
 */
@RestController
@Api(tags = "Api")
@RequestMapping(value = "/icbc-withhold-record")
public class IcbcWithholdRecordController extends BaseController {

    @Autowired
    IcbcWithholdRecordServiceImpl icbcWithholdRecordServiceImpl;

    /**
     * 新增
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增", notes = "新增")
	public ResponseModel<IcbcWithholdRecordDto> save(@RequestBody IcbcWithholdRecordDto model) {
	    model = icbcWithholdRecordServiceImpl.createWithModel(model);
	    return ResponseHelper.buildResponse(model);
	}

	/**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PutMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新", notes = "根据sequenceNbr更新")
	public ResponseModel<IcbcWithholdRecordDto> updateBySequenceNbrIcbcWithholdRecord(@RequestBody IcbcWithholdRecordDto model,@PathVariable(value = "sequenceNbr") Long sequenceNbr) {
	    model.setSequenceNbr(sequenceNbr);
	    return ResponseHelper.buildResponse(icbcWithholdRecordServiceImpl.updateWithModel(model));
	}

	/**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除", notes = "根据sequenceNbr删除")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr){
        return ResponseHelper.buildResponse(icbcWithholdRecordServiceImpl.removeById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询
     *
	 * @param sequenceNbr  主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询单个",  notes = "根据sequenceNbr查询单个")
	public ResponseModel<IcbcWithholdRecordDto> selectOne(@PathVariable Long sequenceNbr) {
	    return ResponseHelper.buildResponse(icbcWithholdRecordServiceImpl.queryBySeq(sequenceNbr));
	}

	/**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/page")
	@ApiOperation(httpMethod = "POST",value = "分页查询",  notes = "分页查询")
	@UserLimits
	public ResponseModel<Page<IcbcWithholdRecordDto>> queryForPage(@RequestParam(value = "current") int current,@RequestParam
                    (value = "size") int size,@RequestBody IcbcWithholdRecordDto dto) {
	    return ResponseHelper.buildResponse(icbcWithholdRecordServiceImpl.queryForIcbcWithholdRecordPage(current,size,dto));
	}

	/**
	 * 列表全部数据查询
     *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "列表全部数据查询",   notes = "列表全部数据查询")
	@GetMapping(value = "/list")
	public ResponseModel<List<IcbcWithholdRecordDto>> selectForList() {
	    return ResponseHelper.buildResponse(icbcWithholdRecordServiceImpl.queryForIcbcWithholdRecordList());
	}

	@TycloudOperation (ApiLevel = UserType.AGENCY, needAuth = false)
	@GetMapping (value = "/exportTotal")
	@ApiOperation (httpMethod = "GET", value = "导出聚富通开卡统计", notes = "导出聚富通开卡统计")
	public ResponseModel<Map<String,Object>> exportTotal(@ApiParam(value = "经销商公司code",example = "87*253*775")@RequestParam(required = false) String developerCode,
													   @ApiParam(value = "区域公司code",example = "87*253*652") @RequestParam(required = false) String regionalCompaniesCode,
													   @ApiParam(value = "省份",example = "610000") @RequestParam(required = false) String province,
													   @ApiParam(value = "市",example = "610700") @RequestParam(required = false) String city,
													   @ApiParam(value = "区",example = "610116") @RequestParam(required = false) String district,
													   @RequestParam(required = false)String year,
													   @RequestParam(required = false)String month,
													   @RequestParam(required = false)String quarter ) {
		return ResponseHelper.buildResponse(icbcWithholdRecordServiceImpl.paymentAmount(developerCode,regionalCompaniesCode,province,city,district,year,month,quarter));
	}


	/**
	 * 列表全部数据查询
	 *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "存量合同电站下载",   notes = "存量合同电站下载")
	@GetMapping(value = "/export")
	public void exportData(HttpServletResponse response, @ApiParam(value = "经销商公司code",example = "87*253*775")@RequestParam(required = false) String developerCode,
						   @ApiParam(value = "区域公司code",example = "87*253*652") @RequestParam(required = false) String regionalCompaniesCode,
						   @ApiParam(value = "省份",example = "610000") @RequestParam(required = false) String province,
						   @ApiParam(value = "市",example = "610700") @RequestParam(required = false) String city,
						   @ApiParam(value = "区",example = "610116") @RequestParam(required = false) String district,
						   @RequestParam(required = false)String year,
						   @RequestParam(required = false)String month,
						   @RequestParam(required = false)String quarter ) {

		icbcWithholdRecordServiceImpl.exportData(response,developerCode,regionalCompaniesCode,province,city,district,year,month,quarter);
	}
}
