package com.yeejoin.amos.boot.module.hygf.biz.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.hygf.api.dto.PowerStationTimeStatisticsBatchDto;
import com.yeejoin.amos.boot.module.hygf.api.dto.PowerStationTimeStatisticsDto;
import com.yeejoin.amos.boot.module.hygf.api.dto.RepaymentBatchDto;
import com.yeejoin.amos.boot.module.hygf.biz.service.impl.PowerStationStatisticsServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import javax.servlet.http.HttpServletResponse;

@RestController
@Api(tags = "电站统计Api")
@RequestMapping(value = "/powerStationStatistics")
public class PowerStationStatisticsController {
    @Autowired
    PowerStationStatisticsServiceImpl powerStationStatisticsService;

    /**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/queryPage")
    @ApiOperation(httpMethod = "GET", value = "场站列表", notes = "场站列表")
    public ResponseModel<Page<PowerStationTimeStatisticsDto>> queryForPage(@RequestParam(value = "current") int current,
                                                                           @RequestParam(value = "size") int size,
                                                                           PowerStationTimeStatisticsDto powerStationTimeStatisticsDto) {
        Page<PowerStationTimeStatisticsDto> page = powerStationStatisticsService.queryForPage(current, size, powerStationTimeStatisticsDto);
        return ResponseHelper.buildResponse(page);
    }

    /**
     * 导出电站Excel
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/exportPowerStationExcel")
    @ApiOperation(httpMethod = "POST", value = "导出电站Excel", notes = "导出电站Excel")
    public ResponseModel<?> exportPowerStationExcel(@RequestBody PowerStationTimeStatisticsBatchDto statisticsBatchDto, HttpServletResponse response) {
        powerStationStatisticsService.exportPowerStationExcel(statisticsBatchDto, response);
        return ResponseHelper.buildResponse(null);
    }

}
