package com.yeejoin.amos.boot.module.hygf.biz.service.impl;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import com.yeejoin.amos.boot.module.hygf.api.dto.FinancingInfoDto;
import com.yeejoin.amos.boot.module.hygf.api.entity.FinancingAuditing;
import com.yeejoin.amos.boot.module.hygf.api.entity.FinancingInfo;
import com.yeejoin.amos.boot.module.hygf.api.entity.FinancingInfoHistory;
import com.yeejoin.amos.boot.module.hygf.api.entity.PeasantHousehold;
import com.yeejoin.amos.boot.module.hygf.api.mapper.FinancingInfoHistoryMapper;
import com.yeejoin.amos.boot.module.hygf.api.service.IFinancingInfoHistoryService;
import com.yeejoin.amos.boot.module.hygf.api.dto.FinancingInfoHistoryDto;
import org.typroject.tyboot.core.rdbms.service.BaseService;
import org.springframework.stereotype.Service;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 投融信息服务实现类
 *
 * @author system_generator
 * @date 2024-10-22
 */
@Service
public class FinancingInfoHistoryServiceImpl extends BaseService<FinancingInfoHistoryDto,FinancingInfoHistory,FinancingInfoHistoryMapper> implements IFinancingInfoHistoryService {
    /**
     * 分页查询
     */
    public Page<Map<String, Object>> queryForFinancingInfoHistoryPage(int current,int size,String ownersName , List<String> status, String province)   {
        Page<Map<String, Object>> page = new Page<>();
        PageHelper.startPage(current,size);
        List<Map<String, Object>> financingList = this.getBaseMapper().getFinancingList(ownersName, status, province);
        PageInfo<Map<String, Object>> pages = new PageInfo(financingList);
        page.setSize(pages.getSize());
        page.setCurrent(pages.getPageNum());
        page.setTotal(pages.getTotal());
        page.setRecords(financingList);
        return page;
    }

    /**
     * 列表查询 示例
     */
    public List<FinancingInfoHistoryDto> queryForFinancingInfoHistoryList()   {
        return this.queryForList("" , false);
    }


    public  void updateState(List<Long> ids){
        LambdaUpdateWrapper<FinancingInfoHistory> up = new LambdaUpdateWrapper<>();
        up.in(FinancingInfoHistory::getPeasantHouseholdId,ids);
        up.set(FinancingInfoHistory::getStatus,"已放款");
        this.getBaseMapper().update(null,up);

    }


    public FinancingInfoHistoryDto  getDataInfo(Long houseHoldId){
        FinancingInfoHistoryDto financingInfoHistoryDto = this.getBaseMapper().selectDataInfo(houseHoldId);
        financingInfoHistoryDto.setFiles(JSONArray.parseArray(financingInfoHistoryDto.getFile()));
         return financingInfoHistoryDto;
     }

    public void upDateMoney(FinancingInfoHistoryDto financingInfoDto) {

        Map<Long, Double> maps = financingInfoDto.getPeasantHouseholds().stream()
                .collect(Collectors.toMap(
                        PeasantHousehold::getSequenceNbr, // key extractor
                        PeasantHousehold::getDisbursementMoney, // value mapper
                        (existingValue, newValue) -> existingValue // merge function
                ));

        LambdaQueryWrapper<FinancingInfoHistory> up = new LambdaQueryWrapper<>();
        up.in(FinancingInfoHistory::getPeasantHouseholdId,maps.keySet());
        List<FinancingInfoHistory> financingInfos = this.getBaseMapper().selectList(up);

        financingInfos.forEach(e->{
            e.setDisbursementMoney(maps.get(e.getPeasantHouseholdId()));
            e.setDisbursementTime(financingInfoDto.getDisbursementTime());
            e.setUnitPrice(financingInfoDto.getUnitPrice());
            e.setFinancingCompaniesName(financingInfoDto.getFinancingCompaniesName());
            e.setBacthNo(financingInfoDto.getBacthNo());
            e.setStatus("放款完成");
            if (financingInfoDto.getFiles() != null){
                e.setFile(JSON.toJSONString(financingInfoDto.getFiles()));
            }
            this.getBaseMapper().updateById(e);
        });
    }
}