package com.yeejoin.amos.boot.module.jxiop.biz.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.jxiop.biz.service.impl.EnergyAccessServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.Map;


@RestController
@Api(tags = "能源接入相关接口")
@RequestMapping(value = "/energyAccess")
public class EnergyAccessController extends BaseController {
    @Autowired
    EnergyAccessServiceImpl energyAccessServiceImpl;

    private final Logger logger = LoggerFactory.getLogger(EnergyAccessController.class);

    @RequestMapping(value = "/getInstalledCapacity", method = RequestMethod.GET)
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "获取并网容量", notes = "获取并网容量")
    public ResponseModel<Page<Map<String, Object>>> getInstalledCapacity(String current, String pageSize, String code, String sourceStationId, String tp) {
        logger.info("获取并网容量接口入参：current ={}，pageSize ={}，code = {},sourceStationId = {},tp = {}",current,pageSize,code,sourceStationId,tp);
        return ResponseHelper.buildResponse(energyAccessServiceImpl.getInstalledCapacity(current, pageSize, code,sourceStationId,tp));
    }

    @RequestMapping(value = "/getQuotaCompleteInfo", method = RequestMethod.GET)
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "获取片区指标完成情况", notes = "获取片区指标完成情况")
    public ResponseModel<Page<Map<String, Object>>> getQuotaCompleteInfo(String current, String pageSize, String code, String sourceStationId, String tp) {
        logger.info("获取片区指标完成情况入参：current ={}，pageSize ={}，code = {},sourceStationId = {},tp = {}",current,pageSize,code,sourceStationId,tp);
        return ResponseHelper.buildResponse(energyAccessServiceImpl.getQuotaCompleteInfo(current, pageSize, code,sourceStationId,tp));
    }
}


