package com.yeejoin.amos.api.openapi.face.orm.entity;

import java.util.Date;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
/**
 * 气瓶基本信息
 * @author kinky
 *
 */
@EqualsAndHashCode(callSuper = true)
@Data
@TableName("tm_cylinder_info")
public class CylinderInfo  extends AbstractBaseEntity{
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	@ApiModelProperty(value = "统一社会信用代码")
	private String creditCode;

	@ApiModelProperty(value = "产权单位名称")
	private String unitName;

	@ApiModelProperty(value = "气瓶唯一标识码")
	private String sequenceCode;

	@ApiModelProperty(value = "设备品种")
	private int cylinderVariety;

	@ApiModelProperty(value = "单位内部编号")
	private String unitInnerCode;

	@ApiModelProperty(value = "充装介质")
	private String fillingMedia;

	@ApiModelProperty(value = "气瓶制造单位")
	private String manufacturingUnit;

	@ApiModelProperty(value = "制造日期")
	private String manufacturingDate;

	@ApiModelProperty(value = "产品名称")
	private String productName;

	@ApiModelProperty(value = "产品编号")
	private String factoryNum;

	@ApiModelProperty(value = "容积（L）")
	private Double volume;

	@ApiModelProperty(value = "产品合格证")
	private String productQualified;

	@ApiModelProperty(value = "质量证明书")
	private String proofQuality;

	@ApiModelProperty(value = "监督检验证书")
	private String supervisionInspec;

	@ApiModelProperty(value = "型式实验证书")
	private String typeExperiments;

	@ApiModelProperty(value = "气瓶状态")
	private int cylinderStatus;

	@ApiModelProperty(value = "阀门制造单位")
	private String valveManufacturUnit;

	@ApiModelProperty(value = "公称工作压力(MPa）")
	private Double nominalWorkPressure;
	
}
