package com.yeejoin.equipmanage.common.entity;

import java.math.BigDecimal;
import java.util.Date;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.equipmanage.common.entity.publics.BaseEntity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 
 *
 * @author wujiang
 * @date 2020-07-07
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("wl_stock_bill_detail")
@ApiModel(value = "StockBillDetail对象", description = "")
public class StockBillDetail extends BaseEntity {

	private static final long serialVersionUID = 1L;

	@ApiModelProperty(value = "货位ID")
	private Long warehouseStructureId;

	@ApiModelProperty(value = "装备定义id")
	private Long equipmentDetailId;

	@ApiModelProperty(value = "规格型号")
	private String standard;

	@ApiModelProperty(value = "批次号")
	private String batchNum;

	@ApiModelProperty(value = "单件装备编码")
	private String singleEquipCode;

	@ApiModelProperty(value = "出入库数量")
	private Double amount;

	@ApiModelProperty(value = "库存明细ID")
	private Long stockDetailId;

	@ApiModelProperty(value = "保养时间")
	private Date maintenanceTime;

	@ApiModelProperty(value = "库存单据id")
	private Long stockBillId;

	@ApiModelProperty(value = "创建人")
	@TableField(value = "creator_id", fill = FieldFill.INSERT)
	private Long creatorId;

	private String rfid;
}
