package com.yeejoin.precontrol.common.dto;

import com.yeejoin.precontrol.common.annotations.ImagePrefix;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 文件Dto
 *
 * @author duanwei
 * @date 2020-07-01
 */
@Data
public class FileDto  extends BaseDto implements Serializable {
    private static final long serialVersionUID = 1L;
    @ApiModelProperty(value = "任务id")
    private Long taskId;
    @ApiModelProperty(value = "人员id")
    private Long personId;
    @ApiModelProperty(value = "人员类型")
    private String personType;
    @ApiModelProperty(value = "文件名称")
    private String fileName;
    @ApiModelProperty(value = "文件路径")
    @ImagePrefix
    private String filePath;
    @ApiModelProperty(value = "创建时间")
    private Date createDate;
}
