package com.yeejoin.precontrol.common.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 奖励表Dto
 *
 * @author duanwei
 * @date 2021-04-06
 */
@Data
public class RewardDto implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "奖励人id")
    /**
     * 奖励人id
     */
    private Long personId;
    @ApiModelProperty(value = "任务id")
    /**
     * 任务id
     */
    private Long taskId;
    @ApiModelProperty(value = "奖励金额")
    /**
     * 奖励金额
     */
    private BigDecimal money;
    @ApiModelProperty(value = "状态（0-未兑换，1-已兑换）")
    /**
     * 状态（0-未兑换，1-已兑换）
     */
    private Integer status;
    @ApiModelProperty(value = "兑换日期")
    /**
     * 兑换日期
     */
    private Date exchangeDate;


}
