package com.yeejoin.precontrol.common.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yeejoin.precontrol.common.entity.Company;
import com.yeejoin.precontrol.common.entity.Person;
import com.yeejoin.precontrol.common.entity.PersonAscription;
import com.yeejoin.precontrol.common.entity.Project;
import com.yeejoin.precontrol.common.entity.ProjectClock;
import com.yeejoin.precontrol.common.entity.ProjectHistory;
import com.yeejoin.precontrol.common.entity.ProjectQrcode;
import com.yeejoin.precontrol.common.exception.BaseException;
import com.yeejoin.precontrol.common.mapper.ProjectQrcodeMapper;
import com.yeejoin.precontrol.common.service.IBadManagementPersonService;
import com.yeejoin.precontrol.common.service.IBadManagementService;
import com.yeejoin.precontrol.common.service.ICompanyService;
import com.yeejoin.precontrol.common.service.IPersonAscriptionService;
import com.yeejoin.precontrol.common.service.IPersonClockService;
import com.yeejoin.precontrol.common.service.IPersonService;
import com.yeejoin.precontrol.common.service.IPersonWorkingHoursService;
import com.yeejoin.precontrol.common.service.IProjectClockService;
import com.yeejoin.precontrol.common.service.IProjectCoordinateService;
import com.yeejoin.precontrol.common.service.IProjectHistoryService;
import com.yeejoin.precontrol.common.service.IProjectQrcodeService;
import com.yeejoin.precontrol.common.service.IProjectService;
import com.yeejoin.precontrol.common.service.ITaskPersonFileService;
import com.yeejoin.precontrol.common.service.ITaskPersonService;
import com.yeejoin.precontrol.common.service.ITaskService;
import com.yeejoin.precontrol.common.service.SmallProService;

import java.util.Date;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 项目出入场二维码 服务实现类
 *
 * @author duanwei
 * @date 2020-06-30
 */
@Service
public class ProjectQrcodeServiceImpl extends ServiceImpl<ProjectQrcodeMapper, ProjectQrcode>
		implements IProjectQrcodeService {
	/**
	 * 项目二维码服务
	 */
	@Autowired
	IProjectQrcodeService iProjectQrcodeService;
	/**
	 * 人员打卡服务
	 */
	@Autowired
	IPersonClockService iPersonClockService;
	/**
	 * 小程序二维码服务
	 */
	@Autowired
	SmallProService smallProService;
	/**
	 * 项目历史服务
	 */
	@Autowired
	IProjectHistoryService iProjectHistoryService;
	/**
	 * 项目服务
	 */
	@Autowired
	IProjectService iProjectService;
	/**
	 * 项目坐标信息服务
	 */
	@Autowired
	IProjectCoordinateService iProjectCoordinateService;
	/**
	 * 人员服务
	 */
	@Autowired
	IPersonService iPersonService;
	/**
	 * 人员关系表服务
	 */
	@Autowired
	IPersonAscriptionService iPersonAscriptionService;
	/**
	 * 项目打卡服务
	 */
	@Autowired
	IProjectClockService iProjectClockService;
	/**
	 * 任务与附件服务
	 */
	@Autowired
	ITaskPersonFileService iTaskPersonFileService;
	/**
	 * 任务与人员服务
	 */
	@Autowired
	ITaskPersonService iTaskPersonService;
	/**
	 * 任务服务
	 */
	@Autowired
	ITaskService iTaskService;
	/**
	 * 违规管理服务
	 */
	@Autowired
	IBadManagementService iBadManagementService;

	@Autowired
	IBadManagementPersonService iBadManagementPersonService;
	/**
	 * 人员与工时服务
	 */
	@Autowired
	IPersonWorkingHoursService iPersonWorkingHoursService;
	

	@Autowired
	ICompanyService icompanyService;
	
	@Override
	public void projectClock(Long personId, Long projectId, String addressName) {

		Project project = iProjectService.getById(projectId);
		
		ProjectClock projectClock = new ProjectClock();
		projectClock.setPersonId(personId);
		projectClock.setType(2);
		projectClock.setClockTime(new Date());
		projectClock.setClockProject(project.getName());
		projectClock.setClockProjectId(Long.valueOf(projectId));
		projectClock.setClockAddress(addressName);
		iProjectClockService.save(projectClock);
		// 打卡的同时也产生一条项目轨迹
		ProjectHistory projectHistory = new ProjectHistory();
		projectHistory.setName(project.getName());
		projectHistory.setStartTime(new Date());
		projectHistory.setRegion(project.getRegion());
		projectHistory.setPersonId(personId);
		projectHistory.setProjectId(Long.valueOf(projectId));

		// 入岗加入项目
		PersonAscription personAscription = iPersonAscriptionService
				.getOne(new LambdaQueryWrapper<PersonAscription>().eq(PersonAscription::getPersonId, personId));
		if (personAscription == null) {
			throw new BaseException("人员的分包商信息不存在");
		}

		Long companyId = personAscription.getCompanyId();

		personAscription.setProjectId(Long.valueOf(projectId));
		// 在岗状态
		personAscription.setStatus(0);
		personAscription.setOrgCode(project.getOrgCode());
		iPersonAscriptionService.updateById(personAscription);
		projectHistory.setCompanyId(companyId);
		iProjectHistoryService.save(projectHistory);

		// 更新人员orgCode
		Person person = iPersonService.getById(personId);
		person.setOrgCode(project.getOrgCode());
		iPersonService.updateById(person);

		// 入岗项目后 对分包商的orgCode进行调整 只加不去除
		Company company = icompanyService.getById(companyId);
		String orgCode = company.getOrgCode();
		if (company != null) {
			// 不是江西电建 不包含则追加
			if (orgCode == null) {
				company.setOrgCode(project.getOrgCode());
				icompanyService.updateById(company);
			} else if (!orgCode.contains(project.getOrgCode())) {
				company.setOrgCode(orgCode + "," + project.getOrgCode());
				icompanyService.updateById(company);
			}
		}

	}
}
