package com.yeejoin.precontrol.common.vo;

import java.util.Date;

import org.springframework.format.annotation.DateTimeFormat;

import com.baomidou.mybatisplus.annotation.TableField;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.yeejoin.precontrol.common.annotations.ImagePrefix;
import com.yeejoin.precontrol.common.annotations.TableFormat;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@Data
public class PersonClockVo {
    private static final long serialVersionUID = -5563226493504171174L;

    @ApiModelProperty(value = "人员信息id")
    @TableFormat(entityName = "rpm_person", fieldName = "name", operFieldName = "personName")
    private Long personId;
    private String personName;
    @TableField(exist = false)
    private String sexLabel;
    @TableField(exist = false)
    @ImagePrefix
    private String headPhoto;
    @TableField(exist = false)
    private String companyName;
    
    @ApiModelProperty(value = "出入场 0入场 1出场")
    private Integer inOrOut;
    @TableField(exist = false)
    private String inOrOutLabel;

    @ApiModelProperty(value = "打卡时间")
    @JsonFormat(pattern = "yyyy-MM-dd",timezone = "GMT+8")
    private Date clockTime;
    @ApiModelProperty(value = "打卡项目id")
    private String clockProjectId;
    @ApiModelProperty(value = "打卡项目名称")
    private String clockProject;
    @ApiModelProperty(value = "打卡地名")
    private String clockAddress;

    private String projectName;
    @ApiModelProperty(value = "设备标识")
    private String deviceNo;
    @ApiModelProperty(value = "身份证号")
    private String idNumber;
    @ApiModelProperty(value = "数字签名")
    private String signature;

    @ApiModelProperty(value = "打卡时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date clockTimeStart;

    @ApiModelProperty(value = "打卡时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date clockTimeEnd;
    
    private Date createDate;
    
	@ApiModelProperty(value = "排序")
	private String sort;

	@ApiModelProperty(value = "排序字段名")
	private String sortName;
	
	@ApiModelProperty(value = "排序顺序")
	private String sortOrder;
}
