package com.yeejoin.amos.fas.business.controller;

import java.util.HashMap;
import java.util.Map;

import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import com.yeejoin.amos.fas.core.util.CommonResponse;
import com.yeejoin.amos.fas.core.util.CommonResponseUtil;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

@RestController
@RequestMapping("/api/region")
@Api("获取当前用户信息api")
public class CurCompanyController extends AbstractBaseController {

	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "获取当前用户信息", notes = "获取当前用户信息")
	@RequestMapping(value = "/current", produces = "application/json;charset=UTF-8", method = RequestMethod.GET)
	public CommonResponse current() {
		
		Map< String, Object> map=new HashMap<>();
		map.put("nickName", getUserInfo().getRealName());
		map.put("company", getSelectedOrgInfo().getCompany());
		map.put("department", getSelectedOrgInfo().getDepartment());
		map.put("role", getSelectedOrgInfo().getRole());
		
		return CommonResponseUtil.success(map);
	}
}
