package com.yeejoin.amos.fas.business.param;

import com.yeejoin.amos.fas.core.common.request.CommonPageable;
import com.yeejoin.amos.fas.core.common.request.CommonRequest;
import org.springframework.util.StringUtils;

import java.util.List;


public class QueryParamUtil {


    public static PointListParam fillPointListParam(List<CommonRequest> queryRequests, CommonPageable commonPageable,
                                                    PointListParam param) {
        for (int i = 0; i < queryRequests.size(); i++) {
            String name = queryRequests.get(i).getName();
            String value = toString(queryRequests.get(i).getValue());
            if (!StringUtils.isEmpty(value)) {
                if ("departmentId".equals(name)) {
                    param.setDepartmentId(Long.valueOf(value));
                } else if ("pointNo".equals(name)) {
                    param.setPointNo(value);
                } else if ("pointName".equals(name)) {
                    param.setPointName(value);
                } else if ("pointId".equals(name)) {
                    param.setPointId(Long.valueOf(value));
                } else if ("inputType".equals(name)) {
                    param.setInputType(value);
                } else if ("fmeaId".equals(name)) {
                    param.setFmeaId(Long.valueOf(value));
                } else if ("bindPointIds".equals(name)) {
                    param.setBindingPointIds(value.split(","));
                }
            }
        }
        if (commonPageable != null) {
            param.setPageNumber(commonPageable.getPageNumber());
            param.setPageSize(commonPageable.getPageSize());
        }
        return param;
    }

    private static String toString(Object value) {
        if (null == value || value == "") {
            return null;
        } else {
            return value.toString();
        }
    }
}
