package com.yeejoin.amos.boot.module.jcs.biz.controller;

import java.util.Arrays;

import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.yeejoin.amos.boot.module.common.api.entity.FirefightersJacket;
import com.yeejoin.amos.boot.module.jcs.api.entity.UserCar;
import com.yeejoin.amos.boot.module.jcs.api.service.IUserCarService;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.biz.common.utils.NameUtils;
import com.yeejoin.amos.boot.module.jcs.api.entity.PowerTransferCompanyResources;
import com.yeejoin.amos.boot.module.jcs.biz.service.impl.PowerTransferCompanyResourcesServiceImpl;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;


/**
 * 调派单位资源
 *
 * @author tb
 * @date 2021-06-17
 */
@RestController
@Api(tags = "调派单位资源Api")
@RequestMapping(value = "/power-transfer-company-resources")
public class PowerTransferCompanyResourcesController extends BaseController {

    @Autowired
    PowerTransferCompanyResourcesServiceImpl powerTransferCompanyResourcesService;
    @Autowired
    IUserCarService userCarService;
    /**
     * 新增调派单位资源
     *
     * @return 返回结果
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/save", method = RequestMethod.POST)
    @ApiOperation(httpMethod = "POST", value = "新增调派单位资源", notes = "新增调派单位资源")
    public boolean savePowerTransferCompanyResources(@RequestBody PowerTransferCompanyResources powerTransferCompanyResources) {
        return powerTransferCompanyResourcesService.save(powerTransferCompanyResources);
    }

    /**
     * 根据id删除
     *
     * @param id id
     * @return 返回结果
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/{id}", method = RequestMethod.DELETE)
    @ApiOperation(httpMethod = "DELETE", value = "根据id删除", notes = "根据id删除")
    public boolean deleteById(@PathVariable Long id) {
        return powerTransferCompanyResourcesService.removeById(id);
    }


    /**
     * 修改调派单位资源
     *
     * @return 返回结果
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/updateById", method = RequestMethod.PUT)
    @ApiOperation(httpMethod = "PUT", value = "修改调派单位资源", notes = "修改调派单位资源")
    public boolean updateByIdPowerTransferCompanyResources(@RequestBody PowerTransferCompanyResources powerTransferCompanyResources) {
        return powerTransferCompanyResourcesService.updateById(powerTransferCompanyResources);
    }




    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/updateById/{code}", method = RequestMethod.POST)
    @ApiOperation(httpMethod = "POST", value = "修改调派单位资源", notes = "修改调派单位资源")
    public boolean updateByResourcesIdPowerTransferCompanyResources(@PathVariable String code) {
        //获取用户所属单位id
        AgencyUserModel agencyUserModel= getUserInfo();
        Long id =null;
        //获取用户已绑定车辆id、
        UserCar userCar=userCarService.selectByAmosUserId(Long.valueOf(agencyUserModel.getUserId()));
        id =userCar!=null?userCar.getCarId():null;
        UpdateWrapper<PowerTransferCompanyResources>   up=new UpdateWrapper<>();
        return  powerTransferCompanyResourcesService.update(new UpdateWrapper<PowerTransferCompanyResources>().eq("resources_id", id).set("status", code));

    }









    /**
     * 根据id查询
     *
     * @param id id
     * @return 返回结果
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/{id}", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "根据id查询", notes = "根据id查询")
    public PowerTransferCompanyResources selectById(@PathVariable Long id) {
        return powerTransferCompanyResourcesService.getById(id);
    }


    /**
     * 列表分页查询
     *
     * @return 返回结果
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/list", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "列表分页查询", notes = "列表分页查询")
    public IPage<PowerTransferCompanyResources> listPage(String pageNum, String pageSize,
                                                         PowerTransferCompanyResources powerTransferCompanyResources) {

        Page<PowerTransferCompanyResources> pageBean;
        QueryWrapper<PowerTransferCompanyResources> powerTransferCompanyResourcesQueryWrapper = new QueryWrapper<>();
        Class<? extends PowerTransferCompanyResources> aClass = powerTransferCompanyResources.getClass();
        Arrays.stream(aClass.getDeclaredFields()).forEach(field -> {
            try {
                field.setAccessible(true);
                Object o = field.get(powerTransferCompanyResources);
                if (o != null) {
                    Class<?> type = field.getType();
                    String name = NameUtils.camel2Underline(field.getName());
                    if (type.equals(Integer.class)) {
                        Integer fileValue = (Integer) field.get(powerTransferCompanyResources);
                        powerTransferCompanyResourcesQueryWrapper.eq(name, fileValue);
                    } else if (type.equals(Long.class)) {
                        Long fileValue = (Long) field.get(powerTransferCompanyResources);
                        powerTransferCompanyResourcesQueryWrapper.eq(name, fileValue);
                    } else if (type.equals(String.class)) {
                        String fileValue = (String) field.get(powerTransferCompanyResources);
                        powerTransferCompanyResourcesQueryWrapper.eq(name, fileValue);
                    } else {
                        String fileValue = (String) field.get(powerTransferCompanyResources);
                        powerTransferCompanyResourcesQueryWrapper.eq(name, fileValue);
                    }
                }
            } catch (Exception e) {
                throw new RuntimeException("系统异常");
            }
        });
        IPage<PowerTransferCompanyResources> page;
        if (StringUtils.isBlank(pageNum) || StringUtils.isBlank(pageSize)) {
            pageBean = new Page<>(0, Long.MAX_VALUE);
        } else {
            pageBean = new Page<>(Integer.parseInt(pageNum), Integer.parseInt(pageSize));
        }
        page = powerTransferCompanyResourcesService.page(pageBean, powerTransferCompanyResourcesQueryWrapper);
        return page;
    }
}

