package com.yeejoin.amos.boot.module.tzs.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.util.Map;

/**
 *  联通回调方法传入参数
 * @author fengwang
 * @date 2021-08-06.
 */
@Data
@Accessors(chain = true)
@ApiModel(value = "CtiDto", description = "CtiDto")
public class CtiDto {

    @ApiModelProperty(value = "企业ID")
    private Integer cid;

    @ApiModelProperty(value = "呼叫类型(1:呼入;2:呼出)")
    private String call_type;

    @ApiModelProperty(value = "外呼主叫(呼入时为呼入的热线号码)")
    private String sysphone;

    @ApiModelProperty(value = "客户号码")
    private String telephone;

    @ApiModelProperty(value = "客户ID")
    private String cusid;

    @ApiModelProperty(value = "呼叫时间")
    private String call_time;

    @ApiModelProperty(value = "服务工号")
    private String empcode;

    @ApiModelProperty(value = "挂机时间")
    private String hangup_time;

    @ApiModelProperty(value = "挂机方(1:坐席挂机;2:客户挂机)")
    private String hangup_flag;

    @ApiModelProperty(value = "按键值(按键的数值,如果多个按键用-连接,如1-2)")
    private String press_key;

    @ApiModelProperty(value = "按键值名称(press_key中按键的含义,多个按键用-连接,如：转组-转人工)")
    private String press_key_name;

    @ApiModelProperty(value = "客户呼叫流水号")
    private String connection_id;

    @ApiModelProperty(value = "坐席呼叫流水号")
    private String service_connection_id;

}
