package com.yeejoin.amos.boot.module.tzs.api.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import java.util.Date;

/**
 * 单位注册许可信息表
 *
 * @author system_generator
 * @date 2022-08-09
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("tz_base_unit_licence")
public class BaseUnitLicence extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 单位编码
     */
	@TableField("unit_code")
    private String unitCode;

    /**
     * 单位名称
     */
	@TableField("unit_name")
    private String unitName;

    /**
     * 许可地址
     */
	@TableField("lic_address")
    private String licAddress;

    /**
     * 证书类型
     */
	@TableField("cert_type")
    private String certType;


    /**
     * 证书类型code
     */
    @TableField("cert_type_code")
    private String certTypeCode;

    /**
     * 证书编号
     */
	@TableField("cert_no")
    private String certNo;

    /**
     * 有效期至
     */
	@TableField("expiry_date")
    private Date expiryDate;

    /**
     * 发证日期
     */
	@TableField("issue_date")
    private Date issueDate;

    /**
     * 变更日期
     */
	@TableField("change_date")
    private Date changeDate;

    /**
     * 许可评审方式
     */
	@TableField("apply_type")
    private String applyType;

    /**
     * 备注
     */
	@TableField("remark")
    private String remark;

    /**
     * 许可项目/检验类型/设备品种编码
     */
	@TableField("item_code")
    private String itemCode;

    /**
     * 许可项目/检验类型/设备品种
     */
	@TableField("item_code_name")
    private String itemCodeName;

    /**
     * 许可子项目/检验项目/充装介质类别code
     */
	@TableField("sub_item_code")
    private String subItemCode;

    /**
     * 许可子项目/检验项目/充装介质类别
     */
	@TableField("sub_item_name")
    private String subItemName;

    /**
     * 许可参数/充装介质名称
     */
	@TableField("parameter")
    private String parameter;


    /**
     * 许可参数/充装介质code
     */
    @TableField("parameter_code")
    private String parameterCode;

    /**
     * 固定检验地址
     */
	@TableField("item_address")
    private String itemAddress;

    /**
     * 发证机关
     */
	private String approvedOrgan;

    /**
     * 发证机关code
     */
	private String approvedOrganCode;

}
