package com.yeejoin.amos.boot.module.tzs.flc.api.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import java.util.Date;

/**
 * 液化气体气瓶充装信息-充装后复查
 *
 * @author system_generator
 * @date 2022-03-04
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("tz_cylinder_filling_check")
public class CylinderFillingCheck extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 充装后复查ID
     */
	@TableField("filling_check_id")
    private String fillingCheckId;

    /**
     * 充装企业名称
     */
	@TableField("filling_unit_name")
    private String fillingUnitName;

    /**
     * 出厂编号
     */
	@TableField("factory_num")
    private String factoryNum;

    /**
     * 气瓶唯一标识码
     */
	@TableField("sequence_code")
    private String sequenceCode;

    /**
     * 充装量在规定范围内
     */
	@TableField("within_scope")
    private Integer withinScope;

    /**
     * 瓶阀及其与瓶口连接的密封良好
     */
	@TableField("sealed_state")
    private Integer sealedState;

    /**
     * 瓶体未出现鼓包变形或泄露等严重缺陷
     */
	@TableField("defective")
    private Integer defective;

    /**
     * 瓶体温度没有异常升高的迹象
     */
	@TableField("abnormal_temperature")
    private Integer abnormalTemperature;

    /**
     * 气瓶粘贴警示标签和充装标签
     */
	@TableField("warning_sign")
    private Integer warningSign;

    /**
     * 液化气瓶充装量符合有关规定，充装后逐瓶称重
     */
	@TableField("compliance")
    private String compliance;

    /**
     * 检查人员姓名
     */
	@TableField("inspector")
    private String inspector;

    /**
     * 检查时间
     */
	@TableField("inspection_date")
    private String inspectionDate;

    /**
     * 同步时间  yyyy-MM-dd HH24:mi:ss
     */
	@TableField("sync_date")
    private Date syncDate;

    /**
     * 0-新增   1-更新  2-删除
     */
	@TableField("sync_state")
    private Integer syncState;

    /**
     * 对接公司编码
     */
	@TableField("app_id")
    private String appId;

    /**
     * 数据完整度
     */
    @TableField("integrity")
    private Double integrity;

}
