package com.yeejoin.amos.boot.module.tzs.flc.api.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import java.util.Date;

/**
 * 液化气体气瓶充装信息-充装记录
 *
 * @author system_generator
 * @date 2022-03-04
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("tz_cylinder_filling_record")
public class CylinderFillingRecord extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 充装记录Id
     */
	@TableField("filling_record_id")
    private String fillingRecordId;

    /**
     * 充装企业名称
     */
	@TableField("filling_unit_name")
    private String fillingUnitName;

    /**
     * 出厂编号
     */
	@TableField("factory_num")
    private String factoryNum;

    /**
     * 气瓶唯一标识码
     */
	@TableField("sequence_code")
    private String sequenceCode;

    /**
     * 充装开始时间
     */
	@TableField("filling_startTime")
    private String fillingStarttime;

    /**
     * 充装结束时间
     */
	@TableField("filling_endTime")
    private String fillingEndtime;

    /**
     * 充装人员姓名
     */
	@TableField("filling_user")
    private String fillingUser;

    /**
     * 充装量（Kg）
     */
	@TableField("filling_quantity")
    private Double fillingQuantity;

    /**
     * 室温
     */
	@TableField("temperature")
    private Double temperature;

    /**
     * 异常情况
     */
	@TableField("abnormal")
    private Integer abnormal;

    /**
     * 同步时间  yyyy-MM-dd HH24:mi:ss
     */
	@TableField("sync_date")
    private Date syncDate;

    /**
     * 1初次同步数据   2上层系统已同步数据   0已删除数据
     */
	@TableField("sync_state")
    private Integer syncState;

    /**
     * 对接公司编码
     */
	@TableField("app_id")
    private String appId;

    /**
     * 数据完整度
     */
    @TableField("integrity")
    private Double integrity;

}
