package com.yeejoin.amos.boot.biz.config;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.handlers.MetaObjectHandler;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.boot.biz.common.utils.RedisKey;
import com.yeejoin.amos.boot.biz.common.utils.RedisUtils;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.reflection.MetaObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;
import org.typroject.tyboot.core.foundation.context.RequestContext;

import java.util.Date;
import java.util.Map;

/**
 * @author Dell
 */
@Component
public class MetaHandler implements MetaObjectHandler {

	@Autowired
    private RedisUtils redisUtils;
	
	protected String getToken() {
		String authToken = RequestContext.getToken();
//		if (authToken == null) {
//			authToken = request.getHeader("X-Access-Token");
//		}
		return authToken;
	}

	/**
	 * 新增数据拦截
	 *
	 * @param metaObject
	 */
	@Override
	public void insertFill(MetaObject metaObject) {		
	   autoFillUser(metaObject, metaObject.getOriginalObject());
	}

	private void autoFillUser(MetaObject metaObject, Object entity) {
		//获取用户信息 以及当前用户登录公司部门，角色
		ReginParams reginParams =
				JSONObject.parseObject(null != redisUtils.get(RedisKey.buildKey(getToken())) ?
						redisUtils.get(RedisKey.buildKey(getToken())).toString() : null, ReginParams.class);
		if (ObjectUtils.isEmpty(reginParams)) {
			return;
		}
		AgencyUserModel agencyUserModel = reginParams.getUserModel();

		if(ObjectUtils.isEmpty(reginParams) || ObjectUtils.isEmpty(agencyUserModel)){
			return;
		}
//		Object entity = metaObject.getOriginalObject();
		if (isExistField("recUserId", entity)) {
			this.setFieldValByName("recUserId", agencyUserModel.getUserId(), metaObject);
		}

		if (isExistField("recUserName", entity)) {
			this.setFieldValByName("recUserName", agencyUserModel.getUserName(), metaObject);
		}
		if (isExistField("recDate", entity)) {
			Date currentDate = new Date();
			this.setFieldValByName("recDate", currentDate, metaObject);
		}
		if (isExistField("allotmentTime", entity)) {
			Date currentDate = new Date();
			this.setFieldValByName("recDate", currentDate, metaObject);
		}


//		if (isExistField("companyCode", entity)) {
//			this.setFieldValByName("companyCode", reginParams.getDepartment().getOrgCode(), metaObject);
//		}				
//		if (isExistField("companyName", entity)) {
//			this.setFieldValByName("companyName", reginParams.getDepartment().getDepartmentName(), metaObject);
//		}
		
		
	}

	private Boolean isExistField(String field, Object obj) {
		if (obj == null || StringUtils.isEmpty(field)) {
			return null;
		}
		Object o = JSONObject.toJSON(obj);
		JSONObject jsonObj = new JSONObject();
		if (o instanceof JSONObject) {
			jsonObj = (JSONObject) o;
		}
		return jsonObj.containsKey(field);
	}

	/**
	 * 更新拦截
	 *
	 * @param metaObject
	 */
	@Override
	public void updateFill(MetaObject metaObject) {
		Object updateEntity = ((Map)metaObject.getOriginalObject()).get("et");
		autoFillUser(metaObject, updateEntity);
		Date currentDate = new Date();
		this.setFieldValByName("updateTime", currentDate, metaObject);
	}
}