package com.yeejoin.amos.boot.module.common.api.dto;

import java.io.Serializable;
import java.util.Date;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.yeejoin.amos.boot.module.common.api.excel.ExplicitConstraint;
import com.yeejoin.amos.boot.module.common.api.excel.RoleNameExplicitConstraint;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@Data
@ApiModel(value = "MaintenancePersonDto", description = "维保单位人员")
public class MaintenancePersonExcleDto implements Serializable {
	/**
	* 
	*/
	@ExcelIgnore
	private static final long serialVersionUID = 1L;

	//@ExcelProperty(value = "序号", index = 0)
	@ApiModelProperty(value = "序号")
	@ExcelIgnore
	private Integer number;

	@ExcelProperty(value = "姓名", index = 0)
	@ApiModelProperty(value = "姓名")
	private String name;

	@ExcelProperty(value = "员工编号", index =1)
	@ApiModelProperty(value = "员工编号")
	protected String  code;
	
	@ExplicitConstraint(indexNum = 2,  sourceClass = RoleNameExplicitConstraint.class, method = "getCompanyAndDeparementTree") //固定下拉内容
	@ExcelProperty(value = "所属单位及部门", index =2)
	@ApiModelProperty(value = "所属单位及部门")	
	private String parentName;
	
	@ExcelIgnore
	private Long parentId;
	
	@ExplicitConstraint(type = "XB", indexNum = 3, sourceClass = RoleNameExplicitConstraint.class)
	@ExcelProperty(value = "性别", index =3)
	@ApiModelProperty(value = "性别")	
	private String gender;
	
	@ExcelProperty(value = "身份证号码", index =4)	
	@ApiModelProperty(value = "身份证号码")
	private String	idNumber;
	
	@ExcelProperty(value = "手机号码", index =5)	
	@ApiModelProperty(value = "手机号码")	
	private String tel;
	
	@ExcelProperty(value = "民族", index =6)	
	@ApiModelProperty(value = "民族")	
	private String nation;
	
	//项目负责人、消防设施操作员
	@ExcelProperty(value = "类别", index =7)	
	@ApiModelProperty(value = "类别")	
	private String category;
	
	@ExcelProperty(value = "统账号", index = 8)
	@ApiModelProperty(value = "系统账户")	
	private String systemAccount;
	
	@ExplicitConstraint(type = "WBRYZT", indexNum =9, sourceClass = RoleNameExplicitConstraint.class) //动态下拉内容
	@ExcelProperty(value = "人员状态", index =9)
	@ApiModelProperty(value = "人员状态")	
	private String status;
	
	@ExplicitConstraint(type = "WBZYZS", indexNum = 10, sourceClass = RoleNameExplicitConstraint.class) //动态下拉内容
	@ExcelProperty(value = "职业资格证书", index =10)
	@ApiModelProperty(value = "职业资格证书")	
	private String professionalCertificate;

	@ExplicitConstraint(type = "WBZYZG", indexNum = 11, sourceClass = RoleNameExplicitConstraint.class) //动态下拉内容
	@ExcelProperty(value = "职业资格", index =11)
	@ApiModelProperty(value = "职业资格")	
	private String qualification;
	
	@ExcelProperty(value = "证书编号", index =12)
	@ApiModelProperty(value = "证书编号")
	private String certificateNo;
	
	@ExcelProperty(value = "注册有效期开始时间", index = 13)
	@ApiModelProperty(value = "注册有效期开始时间")	
	private Date registrationStartTime;
	
	@ExcelProperty(value = "注册有效期结束时间", index = 14)
	@ApiModelProperty(value = "注册有效期结束时间")	
	private Date registrationEndTime;
	
	@ExcelProperty(value = "注册号", index = 15)
	@ApiModelProperty(value = "注册号")
	private String amosAccount;
	
	
}
