package com.yeejoin.amos.boot.module.common.api.service;

import com.baomidou.mybatisplus.core.metadata.IPage;

import java.text.ParseException;
import java.util.List;
import java.util.Map;

/**
 * @author DELL
 */
public interface IDutyCommonService {
    /**
     * 分页查询
     *
     * @param current   当前页
     * @param size      页大小
     * @param beginDate 开始日期
     * @param endDate   结束日期
     * @return IPage<Map < String, Object>>
     */
    IPage<Map<String, Object>> pageList(int current, int size, String beginDate, String endDate) throws ParseException;

    /**
     * 值班明细
     *
     * @param beginDate 开始日期
     * @param endDate   结束日期
     * @return ResponseModel
     */
    List<Map<String, Object>> statisticsDay(String beginDate, String endDate) throws ParseException;

    /**
     * 不分页查询
     *
     * @param beginDate 开始日期
     * @param endDate   结束日期
     * @return ResponseModel
     */
    List<Map<String, Object>> list(Long teamId,String beginDate, String endDate) throws ParseException;

    /**
     * 获取表单参数
     *
     * @return String
     */
    String getGroupCode();

    List downloadList(String beginDate, String endDate) throws ParseException;

    /**
     * 值班数据入库
     *
     * @param dataList 数据
     */
    void saveImportData(List<Map<String, Object>> dataList);

    /**
     * 删除值班数据
     *
     * @param instanceId 实例id
     * @return Boolean
     */
    Boolean deleteDutyData(Long instanceId);

    /**
     * 查询指定条件的值班人信息
     *
     * @param dutyDay  查询条件
     * @param shiftId  班次
     * @param postType 岗位
     * @return List<Map < String, Object>>
     */
    List<Map<String, Object>> dayDutyPersonList(String dutyDay, Long shiftId, String postType);

    /**
     * 查询当前值班人信息
     *
     * @return List<Map < String, Object>>
     */
    List<Map<String, Object>> listOnDutyPerson();
}
