package com.yeejoin.amos.supervision.dao.entity;

import javax.persistence.*;
import java.util.List;


/**
 * The persistent class for the p_check_input database table.
 * 
 */
@Entity
@Table(name="p_check_input")
@NamedQuery(name="CheckInput.findAll", query="SELECT c FROM CheckInput c")
public class CheckInput extends BasicEntity {
	private static final long serialVersionUID = 1L;

	/**
	 * 巡检记录id
	 */
	@Column(name="check_id")
	private Long checkId;

	/**
	 * 检查项id
	 */
	@Column(name="input_id")
	private Long inputId;
	
	
	/**
	 * 检查项名称
	 */
	@Column(name="input_name")
	private String inputName;
	
	/**
	 * 巡检点检查项
	 */
	@Column(name="route_point_item_id")
	private Long routePointItemId;

	/**
	 * 输入值
	 */
	@Column(name="input_value")
	private String inputValue;

	/**
	 * 是否合格
	 */
	@Column(name="is_ok")
	private String isOk;

	/**
	 * 序号
	 */
	@Column(name="order_no")
	private int orderNo;

	/**
	 * 权限系统org code
	 */
	@Column(name="org_code")
	private String orgCode;
	
	/**
	 * 检查点分类id
	 */
	@Column(name="point_classify_id")
	private Long pointClassifyId;
	
	/**
	 * 检查点分类名称
	 */
	@Column(name="point_classify_name")
	private String pointClassifyName;

	/**
	 * 评分
	 */
	private int score;
	
	/**
	 * 备注
	 */
	private String remark;

	/**
	 * 执行人ids
	 */
	@Column(name="user_id")
	private String userId;

	/**
	 * 执行人名称
	 */
	@Column(name="user_name")
	private String userName;

	/**
	 * 执行部门ids
	 */
	@Column(name="dep_id")
	private String depId;

	/**
	 * 执行部门名称
	 */
	@Column(name="dep_name")
	private String depName;

	/**
	 * 安全隐患个数
	 */
	@Column(name="safety_danger_num")
	private int safetyDangerNum;

	/**
	 * 重大隐患个数
	 */
	@Column(name="major_danger_num")
	private int majorDangerNum;

	@Transient
	public List<CheckShot> getCheckShotList() {
		return checkShotList;
	}

	public void setCheckShotList(List<CheckShot> checkShotList) {
		this.checkShotList = checkShotList;
	}

	private List<CheckShot> checkShotList;

	public String getRemark() {
		return remark;
	}

	public void setRemark(String remark) {
		this.remark = remark;
	}

	public CheckInput() {
	}
	
	private Check check;
	
	
	public Long getCheckId() {
		return this.checkId;
	}

	public void setCheckId(Long checkId) {
		this.checkId = checkId;
	}

	public Long getInputId() {
		return this.inputId;
	}

	public void setInputId(Long inputId) {
		this.inputId = inputId;
	}

	public String getInputValue() {
		return this.inputValue;
	}

	public void setInputValue(String inputValue) {
		this.inputValue = inputValue;
	}

	public String getIsOk() {
		return this.isOk;
	}

	public void setIsOk(String isOk) {
		this.isOk = isOk;
	}

	public int getOrderNo() {
		return this.orderNo;
	}

	public void setOrderNo(int orderNo) {
		this.orderNo = orderNo;
	}

	public String getOrgCode() {
		return this.orgCode;
	}

	public void setOrgCode(String orgCode) {
		this.orgCode = orgCode;
	}

	public int getScore() {
		return this.score;
	}

	public void setScore(int score) {
		this.score = score;
	}

	@ManyToOne
	@JoinColumn(name = "checkId", referencedColumnName = "id", updatable = false, insertable = false)
	public Check getCheck() {
		return check;
	}

	public void setCheck(Check check) {
		this.check = check;
	}

	public String getInputName() {
		return inputName;
	}

	public void setInputName(String inputName) {
		this.inputName = inputName;
	}

	public Long getRoutePointItemId() {
		return routePointItemId;
	}

	public void setRoutePointItemId(Long routePointItemId) {
		this.routePointItemId = routePointItemId;
	}

	public Long getPointClassifyId() {
		return pointClassifyId;
	}

	public void setPointClassifyId(Long pointClassifyId) {
		this.pointClassifyId = pointClassifyId;
	}

	public String getPointClassifyName() {
		return pointClassifyName;
	}

	public void setPointClassifyName(String pointClassifyName) {
		this.pointClassifyName = pointClassifyName;
	}

	public String getUserId() {
		return userId;
	}

	public void setUserId(String userId) {
		this.userId = userId;
	}

	public String getUserName() {
		return userName;
	}

	public void setUserName(String userName) {
		this.userName = userName;
	}

	public String getDepId() {
		return depId;
	}

	public void setDepId(String depId) {
		this.depId = depId;
	}

	public String getDepName() {
		return depName;
	}

	public void setDepName(String depName) {
		this.depName = depName;
	}

	public int getMajorDangerNum() {
		return majorDangerNum;
	}

	public void setMajorDangerNum(int majorDangerNum) {
		this.majorDangerNum = majorDangerNum;
	}

	public int getSafetyDangerNum() {
		return safetyDangerNum;
	}

	public void setSafetyDangerNum(int safetyDangerNum) {
		this.safetyDangerNum = safetyDangerNum;
	}
}