package com.yeejoin.amos.maintenance.business.controller;

import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.maintenance.business.constants.XJConstant;
import com.yeejoin.amos.maintenance.business.dto.CheckDto;
import com.yeejoin.amos.maintenance.business.param.CheckInfoPageParam;
import com.yeejoin.amos.maintenance.business.param.CheckRecordParam;
import com.yeejoin.amos.maintenance.business.param.CheckStatisticalParam;
import com.yeejoin.amos.maintenance.business.service.intfc.ICheckService;
import com.yeejoin.amos.maintenance.business.util.*;
import com.yeejoin.amos.maintenance.business.vo.CheckAnalysisVo;
import com.yeejoin.amos.maintenance.business.vo.CheckInfoVo;
import com.yeejoin.amos.maintenance.common.enums.CheckRecordOrderByEnum;
import com.yeejoin.amos.maintenance.common.enums.CheckStatusEnum;
import com.yeejoin.amos.maintenance.core.async.AsyncTask;
import com.yeejoin.amos.maintenance.core.common.request.CommonPageable;
import com.yeejoin.amos.maintenance.core.common.request.CommonRequest;
import com.yeejoin.amos.maintenance.core.common.response.AppPointCheckRespone;
import com.yeejoin.amos.maintenance.core.common.response.GraphInitDataResponse;
import com.yeejoin.amos.maintenance.core.framework.PersonIdentify;
import com.yeejoin.amos.maintenance.core.util.StringUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.foundation.utils.Bean;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import javax.servlet.http.HttpServletResponse;
import javax.xml.transform.*;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import java.io.*;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@RestController
@RequestMapping(value = "/api/check")
@Api(tags = "维保记录api")
public class CheckController extends AbstractBaseController {
    private final Logger log = LoggerFactory.getLogger(CheckController.class);
    @Autowired
    private ICheckService checkService;

    @Autowired
    private AsyncTask asyncTask;

    @Value("${windows.img.path}")
    private String winImgPath;

    @Value("${linux.img.path}")
    private String linuxImgPath;

    @Value("${file.url}")
    private String fileUrl;

    @Value("${amosRefresh.patrol.topic}")
    private String patrolTopic;

    /**
     * 巡检计划查询
     *
     * @param
     * @param
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PersonIdentify
    @ApiOperation(value = "巡检记录查询", notes = "巡检记录查询")
    @RequestMapping(value = "/list", produces = "application/json;charset=UTF-8", method = RequestMethod.POST)
    public CommonResponse qryCheckInfoPage(
            @ApiParam(value = "查询条件") @RequestBody(required = false) List<CommonRequest> queryRequests,
            @ApiParam(value = "分页参数", required = true) CommonPageable commonPageable) {
        ReginParams reginParams = getSelectedOrgInfo();
        String orgCode = getOrgCode(reginParams);
        boolean hasOrgCode = Boolean.TRUE;
        String roleTypeName = getRoleTypeName(reginParams);
        if (0 < queryRequests.size()) {
            for (CommonRequest x : queryRequests) {
                if ("orgCode".equals(x.getName()) && BooleanUtils.isFalse(Boolean.valueOf(x.getValue().toString()))) {
                    hasOrgCode = Boolean.FALSE;
                }
            }
        }
        HashMap<String, Object> paramMap;
        if (hasOrgCode) {
            paramMap = buildMybatisCriterias(orgCode, roleTypeName);
        } else {
            paramMap = buildMybatisCriterias(null, null);
        }
        CheckInfoPageParam param = CheckPageParamUtil.fillCheckInfoParam(queryRequests, commonPageable, paramMap);
        if (ObjectUtils.isEmpty(param.getOrderBy())) {
            param.setOrderBy("checkDate desc");
        }
        Page<CheckInfoVo> list = checkService.getCheckInfo(getToken(), getProduct(), getAppKey(), param);
        return CommonResponseUtil.success(list);
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "导出巡检记录", notes = "导出巡检记录")
    @PostMapping(value = "/export", produces = "application/vnd.ms-excel;charset=UTF-8")
    public void exportCheck(
            @ApiParam(value = "查询条件", required = false) @RequestBody(required = false) List<CommonRequest> queryRequests,
            HttpServletResponse response) {
        ReginParams reginParams = getSelectedOrgInfo();
        String orgCode = getOrgCode(reginParams);
        String roleTypeName = getRoleTypeName(reginParams);
        boolean hasOrgCode = Boolean.TRUE;
        if (0 < queryRequests.size()) {
            for (CommonRequest x : queryRequests) {
                if ("orgCode".equals(x.getName()) && BooleanUtils.isFalse(Boolean.valueOf(x.getValue().toString()))) {
                    hasOrgCode = Boolean.FALSE;
                }
            }
        }
        HashMap<String, Object> paramMap;
        if (hasOrgCode) {
            paramMap = buildMybatisCriterias(orgCode, roleTypeName);
        } else {
            paramMap = buildMybatisCriterias(null, null);
        }
        CheckInfoPageParam param = CheckPageParamUtil.fillCheckInfoParam(queryRequests, null, paramMap);
        param.setPageSize(-1);
        param.setOrderBy("checkDate DESC");
        List<CheckInfoVo> list = checkService.getCheckInfoList(getToken(), getProduct(), getAppKey(), param);
        String fileName = "巡检记录" + new Date().getTime();
        FileHelper.exportExcel(list, "维保记录", "维保记录", CheckInfoVo.class, fileName + ".xls", response);
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "导出巡检记录", notes = "导出巡检记录")
    @RequestMapping(value = "/exportSelectRecord", method = RequestMethod.GET)
    public void exportSelectCheckRecord(
            @ApiParam(value = "查询条件") @RequestParam(required = false) Long[] ids,
            HttpServletResponse response) {
        List<CheckInfoVo> list = checkService.getSelectedCheckInfoList(getToken(), getProduct(), getAppKey(), ids);
        String fileName = "巡检记录" + new Date().getTime();
        FileHelper.exportExcel(list, "巡检记录", "巡检记录", CheckInfoVo.class, fileName + ".xls", response);
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "导出巡检记录图片", notes = "导出巡检记录图片")
    @RequestMapping(value = "/exportImgs", method = RequestMethod.POST)
    public void exportCheckImgs(
            @ApiParam(value = "查询条件") @RequestBody(required = false) List<CommonRequest> queryRequests,
            HttpServletResponse response) {
        ReginParams reginParams = getSelectedOrgInfo();
        String orgCode = getOrgCode(reginParams);
        String roleTypeName = getRoleTypeName(reginParams);
        boolean hasOrgCode = Boolean.TRUE;
        if (0 < queryRequests.size()) {
            for (CommonRequest x : queryRequests) {
                if ("orgCode".equals(x.getName()) && BooleanUtils.isFalse(Boolean.valueOf(x.getValue().toString()))) {
                    hasOrgCode = Boolean.FALSE;
                }
            }
            ;
        }
        HashMap<String, Object> paramMap;
        if (hasOrgCode) {
            paramMap = buildMybatisCriterias(orgCode, roleTypeName);
        } else {
            paramMap = buildMybatisCriterias(null, null);
        }
        CheckInfoPageParam param = CheckPageParamUtil.fillCheckInfoParam(queryRequests, null, paramMap);
        List<Map<String, Object>> list = checkService.getCheckInfoImgsList(param);
        String fileName = "巡检记录图片" + new Date().getTime() + ".zip";
        for (Map<String, Object> map : list) {
            map.put("photoData", fileUrl + map.get("photoData").toString());
        }
        FileHelper.exportZip(list, fileName, response);
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "导出巡检记录图片", notes = "导出巡检记录图片")
    @RequestMapping(value = "/exportImgsByIds", method = RequestMethod.GET)
    public void exportCheckImgs(@ApiParam(value = "查询条件", required = false) @RequestParam(required = false) Long[] ids,
                                HttpServletResponse response) {
        List<Map<String, Object>> list = checkService.getCheckInfoImgsList(ids);
        String fileName = "巡检记录图片" + new Date().getTime() + ".zip";
        for (Map<String, Object> map : list) {
            map.put("photoData", fileUrl + map.get("photoData").toString());
        }
        FileHelper.exportZip(list, fileName, response);
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "保存维保记录-mobile", notes = "保存维保记录-mobile")
    @RequestMapping(value = "/saveRecord", produces = "application/json;charset=UTF-8", method = RequestMethod.POST)
    public CommonResponse saveCheckRecord(
            @ApiParam(value = "检查信息") @RequestBody CheckRecordParam requestParam) {
        try {
            ReginParams reginParams = getSelectedOrgInfo();
            String orgCode = getOrgCode(reginParams);
            requestParam.setOrgCode(orgCode);
            CheckDto checkDto = checkService.saveCheckRecord(requestParam, reginParams);
            return CommonResponseUtil.success(checkDto);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return CommonResponseUtil.failure(e.getMessage());
        }
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "删除维保记录", notes = "删除维保记录")
    @RequestMapping(value = "/testPush", produces = "application/json;charset=UTF-8", method = RequestMethod.POST)
    public CommonResponse deleteCheckById(@ApiParam(value = "维保计划ID", required = true) @RequestBody Long id) {
        try {
            asyncTask.pushCheckMessage(id);
            return CommonResponseUtil.success();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return CommonResponseUtil.failure("删除维保记录失败");
        }
    }


    /**
     * 维保计划删除（支持批量）
     *
     * @param
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "删除维保记录", notes = "删除维保记录")
    @RequestMapping(value = "/deleteCheckById", produces = "application/json;charset=UTF-8", method = RequestMethod.POST)
    public CommonResponse deleteCheckById(@ApiParam(value = "维保计划ID", required = true) @RequestBody List<Long> ids) {
        try {
            checkService.delCheckById(ids);
            return CommonResponseUtil.success();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return CommonResponseUtil.failure("删除维保记录失败");
        }
    }


    /**
     * 根据检查项ID获取所有不合格检查项
     *
     * @param
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "据检查项ID获取所有不合格检查项<font color='blue'>手机app</font>", notes = "据检查项ID获取所有不合格检查项<font color='blue'>手机app</font>")
    @RequestMapping(value = "/queryUnqualifiedInputItem", produces = "application/json;charset=UTF-8", method = RequestMethod.GET)
    public CommonResponse queryUnqualifiedInputItem(@RequestParam(required = true) int checkId) {
        try {
            List<Map> list = checkService.queryUnqualifiedInputItem(checkId);
            return CommonResponseUtil.success(list);
        } catch (Exception e) {
            return CommonResponseUtil.failure(e.getMessage());
        }

    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "获取维保计划维保点(已完成或漏检的维保点)详情信息<font color='blue'>手机app</font>", notes = "获取维保计划维保点(已完成或漏检的维保点)详情信息<font color='blue'>手机app</font>")
    @RequestMapping(value = "/queryCheckPointDetail", produces = "application/json;charset=UTF-8", method = RequestMethod.GET)
    public CommonResponse queryCheckPointDetail(@RequestParam long checkId) {
        try {
            AppPointCheckRespone pointCheckRespone = checkService.queryCheckPointDetail(getToken(), getProduct(), getAppKey(), checkId);
            return CommonResponseUtil.success(pointCheckRespone);
        } catch (Exception e) {
            e.printStackTrace();
            return CommonResponseUtil.failure(e.getMessage());
        }

    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "获取维保计划维保点(已完成或漏检的维保点)详情信息<font color='blue'>手机app</font>", notes = "获取维保计划维保点(已完成或漏检的维保点)详情信息<font color='blue'>手机app</font>")
    @RequestMapping(value = "/v2/queryCheckPointDetail", produces = "application/json;charset=UTF-8", method = RequestMethod.GET)
    public CommonResponse queryCheckPointDetailInVersion2(@RequestParam long checkId) {
        try {
            AppPointCheckRespone pointCheckRespone = checkService.queryCheckPointDetailInVersion2(getToken(), getProduct(), getAppKey(), checkId);
            return CommonResponseUtil.success(pointCheckRespone);
        } catch (Exception e) {
            e.printStackTrace();
            return CommonResponseUtil.failure(e.getMessage());
        }

    }

    /**
     * 获取维保日历数据
     *
     * @param date
     * @return
     */
    @PersonIdentify
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "维保日历-mobile", notes = "维保日历-mobile")
    @GetMapping(value = "/{date}/checkCalendar", produces = "application/json;charset=UTF-8")
    public CommonResponse checkCalendar(
            @ApiParam(value = "date,格式YYYY-MM-DD", required = true) @PathVariable String date) {
        Map<String, Object> params = new HashMap<>();
        ReginParams reginParams = getSelectedOrgInfo();
        String loginOrgCode = getOrgCode(reginParams);
        Map<String, Object> authMap = Bean.BeantoMap(reginParams.getPersonIdentity());
        params.putAll(authMap);
        params.put("checkTime", date);
        params.put("orgCode", loginOrgCode);
        Map<String, Object> map = checkService.checkCalendar(params);
        return CommonResponseUtil.success(map);
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "获取维保点维保记录列表信息<font color='blue'>手机app</font>", notes = "获取维保点维保记录列表信息<font color='blue'>手机app</font>")
    @RequestMapping(value = "/queryCheckRecord", produces = "application/json;charset=UTF-8", method = RequestMethod.POST)
    public CommonResponse queryRecordByPointId(
            @ApiParam(value = "查询条件", required = false) @RequestBody(required = false) List<CommonRequest> queryRequests) {
        ReginParams reginParams = getSelectedOrgInfo();
        String loginOrgCode = getOrgCode(reginParams);
        String roleTypeName = getRoleTypeName(reginParams);
        String departmentId = getDepartmentId(reginParams);
        HashMap<String, Object> req = CheckPageParamUtil.fillInfo(queryRequests);
        if (XJConstant.ROLE_NAME_ADMIN.equals(roleTypeName.toUpperCase())
                || XJConstant.ROLE_NAME_SUPERADMIN.equals(roleTypeName.toUpperCase())) {
            req.put("orgCode", loginOrgCode);
        } else if (XJConstant.ROLE_NAME_DEPTADMIN.equals(roleTypeName.toUpperCase())) {
            req.put("departmentId", departmentId);
        } else {
            if (StringUtil.isNotEmpty(req.get("userId")) && req.get("userId") == null) {
                req.put("userId", getUserId());
            }
        }
        Map<String, Object> map = checkService.queryRecordByPointId(req);
        return CommonResponseUtil.success(map);
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "获取维保记录详情信息<font color='blue'>手机app</font>", notes = "获取维保记录详情信息<font color='blue'>手机app</font>")
    @RequestMapping(value = "/queryCheckDetail", produces = "application/json;charset=UTF-8", method = RequestMethod.GET)
    public CommonResponse queryRecordById(@RequestParam(required = true) int checkId) {
        Map<String, Object> map = checkService.queryRecordById(checkId);
        return CommonResponseUtil.success(map);
    }

    /**
     * 根据维保记录ID获取维保记录详情
     *
     * @param checkId
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "根据维保记录ID获取维保记录详情", notes = "根据维保记录ID获取维保记录详情")
    @RequestMapping(value = "/queryCheckInfo", produces = "application/json;charset=UTF-8", method = RequestMethod.GET)
    public CommonResponse printTaskDetail(@ApiParam(value = "维保记录ID") @RequestParam(required = true) int checkId) {
        Map<String, Object> map = checkService.queryRecordById(checkId);
        String xml = ToolUtils.map2Xml(map, "CheckInfo");
        if (ObjectUtils.isEmpty(xml)) {
            return CommonResponseUtil.failure();
        }
        InputStream inputStream = new ByteArrayInputStream(xml.getBytes());
        ;
        Source source = new StreamSource(inputStream);
        try {
            FileInputStream fis1 = new FileInputStream(
                    this.getClass().getResource("/").getPath() + "temp/checkTemplate.xsl");
            Source template = new StreamSource(fis1);
            Date date = new Date();
            String path = request.getSession().getServletContext().getRealPath("/");
            String dir = path.substring(0, path.indexOf(File.separator) + 1) + "check";
            String html = path.substring(0, path.indexOf(File.separator) + 1) + "check" + File.separator + "task_"
                    + date.getTime() + ".html";
            File dirFile = new File(dir);
            if (!dirFile.exists()) {
                dirFile.mkdirs();
            }

            Result result = new StreamResult(html);
            Transformer transformer = TransformerFactory.newInstance().newTransformer(template);

            transformer.transform(source, result);

            File htmlFile = new File(html);
            FileInputStream fis = new FileInputStream(htmlFile);
            String data = IOUtils.toString(fis, "utf-8");
            fis.close();
            if (htmlFile.exists()) {
                htmlFile.delete();
            }
            return new CommonResponse("SUCCESS", data, "查询成功");
        } catch (TransformerException | IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    /**
     * 获取维保点，维保线路初始数据
     *
     * @return
     */
    //@Authorization(ingore=true)
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "获取维保点初始数据(<font color='blue'>release</font>)", notes = "获取维保点初始数据")
    @RequestMapping(value = "/viewModule/initData", method = RequestMethod.GET, produces = "application/json;charset=UTF-8")
    public CommonResponse getViewModuleInitData() {
        try {
            GraphInitDataResponse graphInitDataResponse = checkService.getViewModuleInitData();
            return CommonResponseUtil.success(graphInitDataResponse);
        } catch (Exception e) {
            e.printStackTrace();
            log.error(e.getMessage(), e);
            return CommonResponseUtil.failure();
        }
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "维保情况统计分析", notes = "维保情况统计分析")
    @RequestMapping(value = "/statisticalAnalysis", method = RequestMethod.POST, produces = "application/json;charset=UTF-8")
    public CommonResponse getCheckStatisticalAnalysis(
            @ApiParam(value = "查询条件", required = false) @RequestBody(required = false) CheckStatisticalParam queryRequests) {
        ReginParams reginParams = getSelectedOrgInfo();
        String loginOrgCode = getOrgCode(reginParams);
        queryRequests.setOrgCode(loginOrgCode);
        List<CheckAnalysisVo> list = checkService.getCheckStatisticalAnalysis(getToken(), getProduct(), getAppKey(), queryRequests);
        return CommonResponseUtil.success(list);
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "导出维保情况统计分析", notes = "导出维保情况统计分析")
    @RequestMapping(value = "/exportStatisticalAnalysis", method = RequestMethod.POST, produces = "application/vnd.ms-excel;charset=UTF-8")
    public void exportStatisticalAnalysis(
            @ApiParam(value = "查询条件", required = false) @RequestBody(required = false) CheckStatisticalParam queryRequests,
            HttpServletResponse response) {
        String userId = getUserId();
        ReginParams reginParams = getSelectedOrgInfo();
        String loginOrgCode = getOrgCode(reginParams);
        queryRequests.setOrgCode(loginOrgCode);
        List<CheckAnalysisVo> list = checkService.getCheckStatisticalAnalysis(getToken(), getProduct(), getAppKey(), queryRequests);
        String fileName = "维保记录" + new Date().getTime();
        FileHelper.exportExcel(list, "维保情况统计分析\"", "维保情况统计分析\"", CheckAnalysisVo.class, fileName + ".xls", response);
    }


    /**
     * 根据检查项ID和检查输入项ID查询图片， 如果输入项ID位0时，查询维保现场照片， 如果不为0查询检查项照片
     *
     * @param checkId
     * @param checkInputId
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "获取检查项照片URL(<font color='blue'>release</font>)", notes = "获取检查项照片URL")
    @RequestMapping(value = "/getCheckPic", method = RequestMethod.GET, produces = "application/json;charset=UTF-8")
    public CommonResponse getCheckPhotosByCheckAndInputId(
            @ApiParam(value = "维保记录ID") @RequestParam(required = true) int checkId,
            @ApiParam(value = "检查输入项ID") @RequestParam(required = false) int checkInputId,
            @ApiParam(value = "分类ID") @RequestParam(required = false) int classifyId) {
        try {
            List<String> list = checkService.getCheckPhotosByCheckAndInputId(checkId, checkInputId, classifyId);
            return CommonResponseUtil.success(list);
        } catch (Exception e) {
            return CommonResponseUtil.failure(e.getMessage());
        }
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "查询最近一条维保记录", notes = "不包括漏检")
    @GetMapping(value = "/{relationId}/last-check")
    public CommonResponse obtainLastCheckRecord(
            @ApiParam(value = "源ids,逗号分隔", required = true) @PathVariable String... relationId) {
        return CommonResponseUtil.success(checkService.obtainLastCheckRecord(relationId));
    }

    @PersonIdentify
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "维保记录分页查询", notes = "维保记录分页查询")
    @GetMapping(value = "/page")
    public CommonResponse getCheckRecord(
            @ApiParam(value = "查询范围") @RequestParam(value = "userId", required = false) String userId,
            @ApiParam(value = "时间范围") @RequestParam(value = "timeType", required = false) String timeType,
            @ApiParam(value = "维保结果") @RequestParam(value = "result", required = false) String result,
            @ApiParam(value = "排序规则") @RequestParam(value = "orderRule", required = false) String orderRule,
            @ApiParam(value = "开始时间") @RequestParam(value = "beginTime", required = false) String beginTime,
            @ApiParam(value = "结束时间") @RequestParam(value = "endTime", required = false) String endTime,
            @ApiParam(value = "维保人员") @RequestParam(value = "personId", required = false) String person,
            @ApiParam(value = "业主单位") @RequestParam(value = "companyId", required = false) String companyId,
            @ApiParam(value = "设施Id") @RequestParam(value = "equipId", required = false) String equipId,
            @ApiParam(value = "当前页") @RequestParam(value = "pageNumber") int pageNumber,
            @ApiParam(value = "页大小") @RequestParam(value = "pageSize") int pageSize) throws Exception {
        HashMap<String, Object> params = new HashMap<>();
        ReginParams reginParams = getSelectedOrgInfo();
        String loginOrgCode = getOrgCode(reginParams);
        Map<String, Object> authMap = Bean.BeantoMap(reginParams.getPersonIdentity());
        params.putAll(authMap);
        params.put("userId", userId);
        params.put("timeType", timeType);
        params.put("result", result);
        if (StringUtils.isNotBlank(orderRule)) {
            params.put("orderRule", CheckRecordOrderByEnum.getEumByCode(orderRule).getOderBy());
        }
        params.put("beginTime", beginTime);
        params.put("endTime", endTime);
        params.put("person", person);
        params.put("companyId", companyId);
        params.put("equipId", equipId);
        params.put("orgCode", loginOrgCode);
        CommonPageable pageable = new CommonPageable(pageNumber, pageSize);
        return CommonResponseUtil.success(checkService.getCheckPage(params, pageable));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "维保记录详情", notes = "维保记录详情")
    @GetMapping(value = "/{id}/detail")
    public CommonResponse getCheckDetail(
            @ApiParam(value = "记录Id",required = true) @PathVariable(value = "id") String id) {
        return CommonResponseUtil.success(checkService.getCheckDetail(id));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "维保记录排序条件列表", notes = "维保记录排序条件列表")
    @RequestMapping(value = "/orderBy/list", method = RequestMethod.GET)
    public ResponseModel getOrderByList() {
        return ResponseHelper.buildResponse(CheckRecordOrderByEnum.getEnumList());
    }

    @ApiOperation(value = "/设备设施维保记录分页列表", notes = "外部接口装备和者水源使用")
    @GetMapping(value = "page/{originalId}/list")
    public ResponseModel getCheckListByOriginalId(
            @PathVariable String originalId,
            @RequestParam(value = "current") int pageNum,
            @RequestParam(value = "size") int pageSize
    ) {
        CommonPageable pageable = new CommonPageable(pageNum, pageSize);
        return ResponseHelper.buildResponse(checkService.getCheckListByOriginalId(originalId, pageable));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "web端维保记录详情")
    @GetMapping(value = "input/{checkId}/detail")
    public ResponseModel inputDetail(@ApiParam(value = "记录主表id") @PathVariable String checkId) {
        return ResponseHelper.buildResponse(checkService.getInputDetail(checkId));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "维保检查结果下拉列表")
    @GetMapping(value = "/isOk-list")
    public ResponseModel statusList() {
        return ResponseHelper.buildResponse(CheckStatusEnum.getEnumList());
    }
}
