package com.yeejoin.amos.maintenance.business.controller;

import com.yeejoin.amos.maintenance.business.util.CommonResponse;
import com.yeejoin.amos.maintenance.business.util.CommonResponseUtil;
import com.yeejoin.amos.maintenance.core.framework.PersonIdentify;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;

/**
 * 获取用户信息
 *
 * @author gaodongdong
 */
@RestController
@RequestMapping(value = "/api/user")
@Api(tags = "用户信息api")
public class UserController extends AbstractBaseController {

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PersonIdentify
    @ApiOperation(value = "获取人员身份信息", notes = " 获取人员身份信息")
    @GetMapping(value = "/identify")
    public CommonResponse personIdentity() {
        return CommonResponseUtil.success(opIdentifyInfo());
    }
}
