package com.yeejoin.amos.maintenance.business.feign;

import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.component.feign.model.FeignClientResult;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

/**
 * @author DELL
 */
@FeignClient(name = "${jcs.fegin.name}",configuration = FeignConfiguration.class)
public interface JCSFeignClient {

    /**
     * 查询用户单位信息
     * @param userId 用户id
     * @return ResponseModel<ReginParams.PersonIdentity>
     */
    @GetMapping(value = "jcs/org-usr/{userId}/userUnit")
    FeignClientResult getUserUnit(@PathVariable String userId);
}
