package com.yeejoin.equipmanage.common.datasync.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.Date;

/**
 * @ProjectName: YeeFireDataProcessRoot
 * @Package: com.yeejoin.equipmanage.common.datasync.entity
 * @ClassName: GeographicalRegion
 * @Author: Jianqiang Gao
 * @Description: 消防车辆
 * @Date: 2021/3/24 11:10
 * @Version: 1.0
 */
@Data
@Accessors(chain = true)
@TableName("ast_firefightingsystem")
@ApiModel(value = "FireFightingSystem对象", description = "消防系统数据")
public class FireFightingSystem implements Serializable {

    private static final long serialVersionUID = 3227490412056629477L;

    @ApiModelProperty(value = "ID")
    @TableId("id")
    private String id;

    @ApiModelProperty(value = "CIM的ID")
    @TableField("mrid")
    private String mRid;

    @ApiModelProperty(value = "站点名称")
    @TableField("stationname")
    private String stationName;

    @ApiModelProperty(value = "站点编码")
    @TableField("stationcode")
    private String stationCode;

    @ApiModelProperty(value = "名称")
    @TableField("name")
    private String name;

    @ApiModelProperty(value = "编码")
    @TableField("code")
    private String code;

    @ApiModelProperty(value = "核心部件mrids")
    @TableField("corecomponentids")
    private String coreComponentIds;

    @ApiModelProperty(value = "系统类别")
    @TableField("systemtype")
    private String systemType;

    @ApiModelProperty(value = "安装日期")
    @TableField("installDate")
    private Date installDate;

    @ApiModelProperty(value = "负责人")
    @TableField("chargePerson")
    private String chargePerson;

    @ApiModelProperty(value = "负责人电话")
    @TableField("chargePersonPhone")
    private String chargePersonPhone;

    @ApiModelProperty(value = "施工单位")
    @TableField("constructionUnit")
    private String constructionUnit;

    @ApiModelProperty(value = "维保单位")
    @TableField("maintenanceunit")
    private String maintenanceUnit;

    @ApiModelProperty(value = "首次维保日期")
    @TableField("firstmaintenancedate")
    private String firstMaintenancedate;

    @ApiModelProperty(value = "维保频率")
    @TableField("maintenancefrequency")
    private String maintenanceFrequency;

    @ApiModelProperty(value = "维保电话")
    @TableField("maintenancephone")
    private String maintenancePhone;

    @ApiModelProperty(value = "创建时间")
    @TableField("createdate")
    private Date createDate;

    @ApiModelProperty(value = "修改时间")
    @TableField("updatedate")
    private Date updateDate;

    @ApiModelProperty(value = "别名")
    @TableField("aliasname")
    private String aliasname;

    @ApiModelProperty(value = "描述")
    @TableField("description")
    private String description;

}