package com.yeejoin.equipmanage.common.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.equipmanage.common.entity.publics.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 *
 *
 * @author wujiang
 * @date 2020-07-07
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("wl_equ_property")
@ApiModel(value = "EquProperty对象", description = "")
public class EquProperty extends BaseEntity {

	private static final long serialVersionUID = 1L;
	@ApiModelProperty(value = "装备详情定义id")
	private Long equipmentDetailId;

	@ApiModelProperty(value = "指标值")
	private String value;

	@ApiModelProperty(value = "是否iot")
	@TableField(exist = false)
	private Boolean isIot;

	@ApiModelProperty(value = "指标id")
	private Long equipmentIndexId;

	@ApiModelProperty(value = "分组")
	@TableField(exist = false)
	private String groupName;

	@ApiModelProperty(value = "单位")
	@TableField(exist = false)
	private String unitName;

	@ApiModelProperty(value = "指标名称")
	@TableField(exist = false)
	private String perfQuotaName;

	@ApiModelProperty(value = "指标key")
	@TableField(exist = false)
	private String equipmentIndexKey;


	@ApiModelProperty(value = "指标name")
	@TableField(exist = false)
	private String equipmentIndexName;

}
