package com.yeejoin.equipmanage.common.entity.dto;

import com.yeejoin.equipmanage.common.entity.vo.VideoListVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 
 * <pre>
 * 在岗监测视图
 * </pre>
 *
 * @author gwb
 * @version $Id: MonitorView.java, v 0.1 2021年9月10日 下午3:09:42 gwb Exp $
 */
@Data
@ApiModel(value = "在岗监测视频轮询", description = "")
public class MonitorViewDto  implements Serializable
{
	
	/**
	 * <pre>
	 * MonitorViewPollingPeriod
	 * </pre>
	 */
	private static final long serialVersionUID = 710637336545868090L;

	@ApiModelProperty(value = "主键 ")
	private Long id;

	/**
	 * 视图名称
	 */
	@ApiModelProperty(value = "视图名称")
	private String viewName;

	/**
	 * 轮询周期
	 */
	@ApiModelProperty(value = "轮询周期")
	private Integer pollingPeriod;

	/**
	 * 选中视频列表
	 */
	@ApiModelProperty(value = "选中视频列表")
	private List<VideoListVo> checkedVideoDTOList;

	/**
	 * 未选中视频列表
	 */
	@ApiModelProperty(value = "未选中视频列表")
	private List<VideoListVo> uncheckedVideoDTOList;
	

    @ApiModelProperty(value = "创建时间 ")
    private Date createDate;
}
