package com.yeejoin.equipmanage.common.utils;

import org.jsoup.Jsoup;
import org.jsoup.nodes.Attribute;
import org.jsoup.nodes.Attributes;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

import java.util.*;

public class DocUtil {
	private DocUtil() {
	}

	/**
	 * doc对应的html转换
	 * @param html
	 * @return
	 */
	public static Map<String, Object> processDoc(String html){
		String res = html.replace("background-color:#ffffff","");
		Document doc = Jsoup.parse(res);
		updateStyle(doc);
		
		Elements elements = doc.getElementsByTag("p");
		List<String> nodes = new ArrayList<>();
		int index = 1;
		for (Element element : elements) {
			Attributes attributes = element.attributes();
			List<Attribute> list = attributes.asList();
			int level = -1;
			String id = null;
			for (Attribute attr : list) {
				if("id".equals(attr.getKey())){
					level = Integer.parseInt(attr.getValue().split("-")[1]);
					if(level>5){
			            level = -1;
			          }
					 attr.getValue();
				}
			}
			if(level>-1){
				Elements children = element.children();
				StringBuilder sb = new StringBuilder();
				for (Element element2 : children) {
					sb.append(element2.text());
				}
				nodes.add(level+" "+sb.toString());
				element.attr("id", "id"+index++);
			}
		}
		MyNode root = new MyNode();
		root.setId("id");
		MyNode last = root;
		int lastlevel = -1;
		index = 1;
		for (String node : nodes) {
			int level = Integer.parseInt(node.substring(0, 1));
			String text = node.substring(2);
			MyNode n = new MyNode(text,level);
			n.setId("id"+index++);
			if(level > lastlevel){
				last.append(n);
				last = n;
			}else if(level == lastlevel){
				last.ggParent().append(n);
				last = n;
			}else if(level < lastlevel){
				while(true){
					last = last.ggParent();
					if(last.ggLevel()<level){
						break;
					}
				}
				last.append(n);
				last = n;
			}
			lastlevel = level;
		}

		Map<String,Object> map = new HashMap<>();
		map.put("nodes", root.getChildren());
		map.put("html", doc.toString());
		return map;
	}
	

	/**
	 * docx对应的html转换
	 * @param html
	 * @return
	 */
	public static Map<String, Object> processDocx(String html){
		String res = html.replace("background-color:#ffffff","");
		Document doc = Jsoup.parse(res);
		updateStyle(doc);
		Elements head = doc.getElementsByTag("head");
		head.append("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\"> ");
		Elements elements = doc.getElementsByTag("p");
		List<String> nodes = new ArrayList<>();
		int index = 1;
		for (Element element : elements) {
			Attributes attributes = element.attributes();
			List<Attribute> list = attributes.asList();
			int level = -1;
			for (Attribute attr : list) {
				if("class".equals(attr.getKey())){
					List<String> asList = Arrays.asList(attr.getValue().split(" "));
					for (String s : asList) {
						if(s.startsWith("X")&&s.length()==2){
							try {
								level = Integer.parseInt(s.substring(1));
							} catch (Exception e) {
								e.printStackTrace();
							}
						}
					}
				}
			}
			if(level>-1){
				Elements children = element.children();
				StringBuilder sb = new StringBuilder();
				for (Element element2 : children) {
					sb.append(element2.text());
				}
				nodes.add(level+" "+sb.toString());
				element.attr("id", "id"+index++);
			}
		}
		MyNode root = new MyNode();
		root.setId("id");
		MyNode last = root;
		int lastlevel = -1;
		index = 1;
		for (String node : nodes) {
			int level = Integer.parseInt(node.substring(0, 1));
			String text = node.substring(2);
			MyNode n = new MyNode(text,level);
			n.setId("id"+index++);
			if(level > lastlevel){
				last.append(n);
				last = n;
			}else if(level == lastlevel){
				last.ggParent().append(n);
				last = n;
			}else if(level < lastlevel){
				while(true){
					last = last.ggParent();
					if(last.ggLevel()<level){
						break;
					}
				}
				last.append(n);
				last = n;
			}
			lastlevel = level;
		}

		Map<String,Object> map = new HashMap<>();
		map.put("nodes", root.getChildren());
		map.put("html", doc.toString());
		return map;
	}
	
	//修改样式为白色
	private static void updateStyle(Document doc) {


		Elements table = doc.getElementsByTag("table");
		table.attr("style", "width: 100%");
	}
}
