package com.yeejoin.amos.boot.module.ccs.biz.controller;

import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.ccs.api.dto.FireEquipmentSignalLogDto;
import com.yeejoin.amos.boot.module.ccs.biz.service.impl.FireEquipmentSignalLogServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.text.ParseException;
import java.util.List;

/**
 * 设备报警信息日志表
 *
 * @author system_generator
 * @date 2021-11-09
 */
@RestController
@Api(tags = "设备信号信息日志表Api")
@RequestMapping(value = "/fire-equipment-signal-log")
public class FireEquipmentSignalLogController extends BaseController {

    @Autowired
    FireEquipmentSignalLogServiceImpl fireEquipmentSignalLogServiceImpl;

    /**
     * 列表全部数据查询
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "设备报警信息日志表列表", notes = "设备报警信息日志列表")
    @GetMapping(value = "/list")
    public ResponseModel<List<FireEquipmentSignalLogDto>> selectForList() {
        return ResponseHelper.buildResponse(fireEquipmentSignalLogServiceImpl.fireEquipmentAlarmLogList());
    }

    /**
     * 今日未确认设备报警信息列表
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "今日未确认设备报警信息列表", notes = "今日未确认设备报警信息列表，跑马灯使用")
    @GetMapping(value = "/today/list")
    public ResponseModel<List<FireEquipmentSignalLogDto>> todayAlarmList(
            @ApiParam(value = "换流站编号") @RequestParam(required = false) String stationCode) throws ParseException {
        return ResponseHelper.buildResponse(fireEquipmentSignalLogServiceImpl.todayAlarmLogList(stationCode));
    }
}
