package com.yeejoin.equipmanage.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.google.common.collect.Lists;
import com.yeejoin.equipmanage.common.entity.CarProperty;
import com.yeejoin.equipmanage.common.entity.vo.CarIndexVo;
import com.yeejoin.equipmanage.common.entity.vo.CarPropertyVo;
import com.yeejoin.equipmanage.mapper.CarPropertyMapper;
import com.yeejoin.equipmanage.service.ICarPropertyService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 *  服务实现类
 *
 * @author wujiang
 * @date 2020-07-07
 */
@Service
public class CarPropertyServiceImpl extends ServiceImpl<CarPropertyMapper, CarProperty> implements ICarPropertyService {

    @Autowired
    CarPropertyMapper carPropertyMapper;

    @Override
    public List<CarProperty> getCarPropListByIotCode(String iotCode) {
        return carPropertyMapper.getCarPropListByIotCode(iotCode);
    }

    @Override
    public List<CarPropertyVo> getCarPropertyList(CarIndexVo carIndexVo) {
        List<CarPropertyVo> carPropertyList = carPropertyMapper.getCarPropertyList(carIndexVo);
        if (carPropertyList!= null && !carPropertyList.isEmpty()) {
            return carPropertyList;
        } else {
            return Lists.newArrayList();
        }
    }

    @Override
    public List<CarPropertyVo> getCarPropertyListByCarIds(List<Long> carIds) {
        List<CarPropertyVo> carPropertyList = carPropertyMapper.getCarPropertyListByCarIds(carIds);
        if (carPropertyList!= null && !carPropertyList.isEmpty()) {
            return carPropertyList;
        } else {
            return Lists.newArrayList();
        }
    }


    public Map<String, Object>  getCarPropertyByCarIds(List<Long> carIds) {
        Map<String, Object> carPropertyByCarIds = carPropertyMapper.getCarPropertyByCarIds(carIds);
        if (carPropertyByCarIds!= null && !carPropertyByCarIds.isEmpty()) {
            return carPropertyByCarIds;
        } else {
            return new HashMap<>();
        }
    }
}
