package com.yeejoin.amos.boot.module.jcs.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yeejoin.amos.boot.biz.common.utils.DateUtils;
import com.yeejoin.amos.boot.module.jcs.api.dto.AlertCallePowerTransferRo;
import com.yeejoin.amos.boot.module.jcs.api.dto.PowerTransferCompanyDto;
import com.yeejoin.amos.boot.module.jcs.api.dto.PowerTransferCompanyResourcesDto;
import com.yeejoin.amos.boot.module.jcs.api.entity.AlertCalled;
import com.yeejoin.amos.boot.module.jcs.api.entity.PowerTransferCompany;
import com.yeejoin.amos.boot.module.jcs.api.entity.PowerTransferCompanyResources;
import com.yeejoin.amos.boot.module.jcs.api.entity.PowerrTransferLog;
import com.yeejoin.amos.boot.module.jcs.api.enums.FireBrigadeTypeEnum;
import com.yeejoin.amos.boot.module.jcs.api.mapper.PowerrTransferLogMapper;
import com.yeejoin.amos.boot.module.jcs.api.service.IPowerrTransferLogService;
import com.yeejoin.amos.boot.module.jcs.api.dto.PowerrTransferLogDto;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.typroject.tyboot.core.foundation.utils.Bean;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.rdbms.service.BaseService;
import org.springframework.stereotype.Service;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 力量调派发送信息记录表服务实现类
 *
 * @author litw
 * @date 2021-11-05
 */
@Service
public class PowerrTransferLogServiceImpl extends BaseService<PowerrTransferLogDto,PowerrTransferLog,PowerrTransferLogMapper> implements IPowerrTransferLogService {

    @Autowired
    PowerTransferCompanyServiceImpl powerTransferCompanyService;

    @Autowired
    PowerTransferCompanyResourcesServiceImpl powerTransferCompanyResourcesService;

    @Autowired
    AlertCalledServiceImpl iAlertCalledService;

    /**
     * 分页查询
     */
    public Page<PowerrTransferLogDto> queryForPowerrTransferLogPage(Page<PowerrTransferLogDto> page)   {
        return this.queryForPage(page, null, false);
    }

    /**
     * 列表查询 示例
     */
    public List<PowerrTransferLogDto> queryForPowerrTransferLogList()   {
        return this.queryForList("" , false);
    }

    @Override
    public PowerrTransferLogDto selectOneDetails(Long id, String type) {
        // 队伍
        if("0".equals(type)) {
            LambdaQueryWrapper<PowerrTransferLog> queryWrapper = new LambdaQueryWrapper<>();
            PowerrTransferLogDto dto = new PowerrTransferLogDto();
            queryWrapper.eq(PowerrTransferLog::getTeamId,id);
            List<PowerrTransferLog> list = this.list(queryWrapper);

            PowerTransferCompany company = powerTransferCompanyService.getById(id);

            list.stream().forEach(e->{
                dto.setReceiveName(dto.getReceiveName() == null ? "".concat(e.getReceiveName() == null ? "" : e.getReceiveName()) : "".equals(e.getReceiveName()) ?  "".concat(e.getReceiveName()) : dto.getReceiveName().concat("/").concat(e.getReceiveName() == null ? "" : e.getReceiveName()) );
                dto.setSendTime(e.getSendTime());
                dto.setSendContent(e.getSendContent());
                dto.setRecUserName(e.getRecUserName());

                if(!ValidationUtil.isEmpty(company)) {
                    dto.setSendContent(company.getTaskInformation());
                }

            });
            return dto;
        }

        // 资源
        if("1".equals(type)) {
            LambdaQueryWrapper<PowerrTransferLog> queryWrapper = new LambdaQueryWrapper<>();
            PowerrTransferLogDto dto = new PowerrTransferLogDto();
            queryWrapper.eq(PowerrTransferLog::getResourceId,id);
            PowerrTransferLog powerrTransferLog = this.getOne(queryWrapper);
            if(null != powerrTransferLog) {
                PowerTransferCompanyResources resources = powerTransferCompanyResourcesService.getById(id);
                PowerTransferCompany byId = powerTransferCompanyService.getById(resources.getPowerTransferCompanyId());
                powerrTransferLog.setSendContent(byId.getTaskInformation());
                Bean.toPo(powerrTransferLog,dto);
            }
            return dto;
        }

        return new PowerrTransferLogDto();
    }


   public void savePowerTransferLog( AlertCallePowerTransferRo alertCallePowerTransferRo, List<String> persons) {
       String powerTransType = alertCallePowerTransferRo.getPowerTransType();
       AlertCalled alertCalled = iAlertCalledService.getById(alertCallePowerTransferRo.getSequenceNbr());
       String personName = "";
       if  (persons.size() > 0) {
           personName = StringUtils.join(persons.toArray(),",");
        }
       final  String  receiveName = personName;
        List<PowerrTransferLog> list = new ArrayList<>();
        if (FireBrigadeTypeEnum.专职消防队.getKey().equals(powerTransType)) {
            List<Object> companyDetail = JSON.parseArray(JSON.toJSON(alertCallePowerTransferRo.getCompany()).toString(),Object.class);
            for (Object powerTransferCompanyDto : companyDetail) {
                PowerTransferCompanyDto powerDto = JSON.parseObject(JSON.toJSON(powerTransferCompanyDto).toString(), PowerTransferCompanyDto.class);
                List<PowerTransferCompanyResourcesDto> powerTransferCompanyResourcesDtoList = powerDto.getPowerTransferCompanyResourcesDtoList();
                powerTransferCompanyResourcesDtoList.stream().forEach(f-> {
                    PowerrTransferLog pw = new PowerrTransferLog();
                    pw.setResourceId(f.getSequenceNbr());
                    pw.setReceiveName(receiveName);
                    pw.setRecUserName(alertCalled.getRecUserName());
                    try {
                        pw.setSendTime(DateUtils.dateTimeToDateString(new Date(System.currentTimeMillis())));
                    } catch (ParseException ex) {
                        ex.printStackTrace();
                    }
                    pw.setPowerTransferCompanyResource(f.getSequenceNbr());
                    pw.setPowerTransferCompany(f.getPowerTransferCompanyId());
                    list.add(pw);
                });
            }
        } else if (FireBrigadeTypeEnum.医疗救援队.getKey().equals(powerTransType) || FireBrigadeTypeEnum.监控大队.getKey().equals(powerTransType)) {
                List<Object> companyDetail = JSON.parseArray(JSON.toJSON(alertCallePowerTransferRo.getCompany()).toString(),Object.class);
                for (Object powerTransferCompanyDto : companyDetail) {
                    PowerTransferCompanyDto powerDto = JSON.parseObject(JSON.toJSON(powerTransferCompanyDto).toString(), PowerTransferCompanyDto.class);
                    PowerrTransferLog pw = new PowerrTransferLog();
                    pw.setTeamId(powerDto.getSequenceNbr());
                    pw.setReceiveName(receiveName);
                    pw.setRecUserName(alertCalled.getRecUserName());
                    try {
                        pw.setSendTime(DateUtils.dateTimeToDateString(new Date(System.currentTimeMillis())));
                    } catch (ParseException ex) {
                        ex.printStackTrace();
                    }
                    pw.setPowerTransferCompany(powerDto.getCompanyId());
                    list.add(pw);
                }
        }
        this.saveBatch(list);
    }

}