package com.yeejoin.amos.boot.module.hygf.api.dto;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.extension.handlers.FastjsonTypeHandler;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 设计信息
 *
 * @author system_generator
 * @date 2023-07-14
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value="DesignInformationDto", description="设计信息")
public class DesignInformationDto  extends BaseDto {

   private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "典型设计图信息",example = "[{\"uid\": \"0.2fcslywd2ry\", \"name\": \"11.dws\", \"url\": \"/upload/common/74FD9327D410951E60319A3215641DDE.dws\"}]")
    @TableField(typeHandler = FastjsonTypeHandler.class)
    private List<Object> typicalDiagram;
    /**
     * 典型设计图信息
     */
    @ApiModelProperty(value = "典型设计图信息",example = "[{\"uid\": \"0.qbiq6dutwl\", \"name\": \"11.dwg\", \"url\": \"/upload/common/4B4C1D996B21A1F4CBBD9B72A92AFBA0.dwg\"}]")
    @TableField(typeHandler = FastjsonTypeHandler.class)
    private List<Object> engineering;


    @ApiModelProperty(value = "组件排布图",example = "[{\"uid\": \"0.9bn4t1r35hf\", \"name\": \"11.dwg\", \"url\": \"/upload/common/E42849CBDE341C85870262917024A.dwg\"}]")
    @TableField(typeHandler = FastjsonTypeHandler.class)
    private List<Object> componentLayout;

    @ApiModelProperty(value = "组件支架图",example = "[{\"uid\": \"0.26j7x3whyx8\", \"name\": \"11.dws\", \"url\": \"/upload/common/D9B23BWADAWDAWD931251F9C1A257.dws\"}]")
    @TableField(typeHandler = FastjsonTypeHandler.class)
    private List<Object> componentBracket;

    @ApiModelProperty(value = "组串接线图",example = "[{\"uid\": \"0.36j7x3whyx8\", \"name\": \"11.dws\", \"url\": \"/upload/common/D9B23B3407AWADAWF9C1A257.dws\"}]")
    @TableField(typeHandler = FastjsonTypeHandler.class)
    private List<Object> connectionLine;

    @ApiModelProperty(value = "一次接线图",example = "[{\"uid\": \"0.46j7x3whyx8\", \"name\": \"11.dws\", \"url\": \"/upload/common/D9B23B3DWAD51F9C1A257.dws\"}]")
    @TableField(typeHandler = FastjsonTypeHandler.class)
    private List<Object> onceLine;

    @ApiModelProperty(value = "组件",example = "[{\"gl\":\"245W\",\"wlbm\":\"1\",\"pzsl\":\"1\",\"bk\":\"30b\",\"Symbol_key\":\"11750F96-B831-4D1F-87F0-5EB18A0C0301\",\"wlmc\":\"1\",\"lx\":\"danjing\",\"dcpgg\":\"1\",\"zgl\":1,\"dsm\":\"dm\"}]")
    @TableField(typeHandler = FastjsonTypeHandler.class)
    private List<Object> assembly;

    @ApiModelProperty(value = "逆变器",example = "[{\"xl\":\"bx\",\"gl\":1,\"wlbm\":\"1\",\"pzsl\":\"1\",\"Symbol_key\":\"0665F5B8-19E6-470B-BADC-C94A5C4081E0\",\"wlmc\":\"1\",\"xw\":\"dx\"}]")
    @TableField(typeHandler = FastjsonTypeHandler.class)
    private List<Object> inverter;

    @ApiModelProperty(value = "电表箱",example = "[{\"wlbm\":\"1\",\"cz\":\"smc\",\"gn\":\"dz\",\"pzsl\":\"1\",\"Symbol_key\":\"49CE32B8-F22B-4007-B4A3-315A55BE7AEA\",\"wlmc\":\"1\",\"swms\":\"qesw\",\"xw\":\"dx\"}]")
    @TableField(typeHandler = FastjsonTypeHandler.class)
    private List<Object> electricityMeter;

    @ApiModelProperty(value = "电缆",example = "[{\"xh\":\"ZR-YJV22\",\"gg\":\"3×50+1×25\",\"wlbm\":\"的非官方的功夫格斗\",\"pzsl\":55,\"Symbol_key\":\"BD49C438-C85F-4A88-B105-2757F0EC454A\",\"wlmc\":\"554545\"},{\"xh\":\"ZR-YJV22\",\"gg\":\"3×50+1×25\",\"wlbm\":\"的非官方的功夫格斗\",\"pzsl\":55,\"Symbol_key\":\"ED62C48A-0E32-459C-B02C-ED4C7475E508\",\"wlmc\":\"554545\"},{\"xh\":\"ZR-YJV22\",\"gg\":\"3×50+1×25\",\"wlbm\":\"的非官方的功夫格斗\",\"pzsl\":55,\"Symbol_key\":\"14EF658D-446A-4D80-AE99-AF62898A43D2\",\"wlmc\":\"554545\"},{\"xh\":\"ZR-YJV22\",\"gg\":\"3×50+1×25\",\"wlbm\":\"的非官方的功夫格斗\",\"pzsl\":55,\"Symbol_key\":\"6E8A3BEE-9D6B-489C-9339-0362B8892660\",\"wlmc\":\"554545\"}]")
    @TableField(typeHandler = FastjsonTypeHandler.class)
    private List<Object> cable;

    @ApiModelProperty(value = "支架",example = "[{\"xh\":\"ZR-YJV22\",\"gg\":\"3×50+1×25\",\"wlbm\":\"的非官方的功夫格斗\",\"pzsl\":55,\"Symbol_key\":\"BD49C438-C85F-4A88-B105-2757F0EC454A\",\"wlmc\":\"554545\"},{\"xh\":\"ZR-YJV22\",\"gg\":\"3×50+1×25\",\"wlbm\":\"的非官方的功夫格斗\",\"pzsl\":55,\"Symbol_key\":\"ED62C48A-0E32-459C-B02C-ED4C7475E508\",\"wlmc\":\"554545\"},{\"xh\":\"ZR-YJV22\",\"gg\":\"3×50+1×25\",\"wlbm\":\"的非官方的功夫格斗\",\"pzsl\":55,\"Symbol_key\":\"14EF658D-446A-4D80-AE99-AF62898A43D2\",\"wlmc\":\"554545\"},{\"xh\":\"ZR-YJV22\",\"gg\":\"3×50+1×25\",\"wlbm\":\"的非官方的功夫格斗\",\"pzsl\":55,\"Symbol_key\":\"6E8A3BEE-9D6B-489C-9339-0362B8892660\",\"wlmc\":\"554545\"}]")
    @TableField(typeHandler = FastjsonTypeHandler.class)
    private List<Object> support;

    @ApiModelProperty(value = " 防滑雪措施",example = "wxfhxcs")
    private String antiSkiing;

    @ApiModelProperty(value = " 防滑雪措施备注",example = "防滑雪措施备注")
    private String antiSkiingNotes;

    @ApiModelProperty(value = " 抽检",example = "f")
    private String spotCheck;

    @ApiModelProperty(value = " 抽检意见",example = "抽检意见")
    private String spotCheckOpinion;

    @ApiModelProperty(value = "是否定制",example = "f")
    private String isokCustomized;

    @ApiModelProperty(value = "是否加固",example = "f")
    private String windResistant;

    @ApiModelProperty(value = "试点方案",example = "bsd")
    private String pilotProgram;

    @ApiModelProperty(value = " 试点物料",example = "bsd")
    private String pilotMaterials;

    @ApiModelProperty(value = "方位角",example = "1")
    private String azimuth;

    @ApiModelProperty(value = "倾角",example = "1")
    private String dipAngle;

    @ApiModelProperty(value = " 应用场景",example = "应用场景")
    private String applicationScenario;

    @ApiModelProperty(value = "应用场景数量",example = "11")
    private Integer applicationScenarioNum;

    @ApiModelProperty(value = "支架方案",example = "支架方案")
    private String supportScheme;

    @ApiModelProperty(value = "支架方案数量",example = "11")
    private Integer supportSchemeNum;

    @ApiModelProperty(value = "特殊方案",example = "特殊方案")
    private String specialPlan;

    @ApiModelProperty(value = "特殊方案数量",example = "111")
    private Integer specialPlanNum;

    @ApiModelProperty(value = "农户id",example = "1854346995242635266")
    private String peasantHouseholdId;

}
