package com.yeejoin.amos.boot.module.hygf.api.dto;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.extension.handlers.FastjsonTypeHandler;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;
import java.util.List;

/**
 * 存量合同电站
 *
 * @author system_generator
 * @date 2024-10-18
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "HistoryPeasantHouseholdDto", description = "存量合同电站")
public class HistoryPeasantHouseholdDto extends BaseDto {
    @ExcelIgnore
    private static final long serialVersionUID = 1L;
    @ExcelProperty(value = "农户姓名", index = 0)
    @ApiModelProperty(value = "农户姓名")
    private String ownersName;

    @ExcelProperty(value = "身份证号", index = 1)
    @ApiModelProperty(value = "身份证号")
    private String idCard;

    @ExcelProperty(value = "联系方式", index = 2)
    @ApiModelProperty(value = "联系方式")
    private String telephone;

    @ExcelProperty(value = "省份", index = 3)
    @ApiModelProperty(value = "省份")
    private String province;

    @ExcelProperty(value = "房屋地址", index = 4)
    @ApiModelProperty(value = "房屋地址")
    private String houseAddress;

    @ExcelProperty(value = "并网容量(kW)", index = 5)
    @ApiModelProperty(value = "并网容量")
    private String basicGridCapacity;

    @ExcelProperty(value = "并网日期", index = 6)
    @ApiModelProperty(value = "并网日期")
    private String basicGridDate;

    @ExcelProperty(value = "农户编号", index = 7)
    @ApiModelProperty(value = "农户编号")
    private String peasantHouseholdNo;

    @ExcelProperty(value = "购电合同", index = 8)
    @ApiModelProperty(value = "购电合同")
    private String powerPurchaseContract;

    @ExcelProperty(value = "租赁合同", index = 9)
    @ApiModelProperty(value = "租赁合同")
    private String leaseContract;
    @ExcelIgnore
    private String files;


    /**
     * 状态
     */
    @ExcelIgnore
    private String status;

    /**
     * 附件地址
     */
    @ExcelIgnore
    @TableField(typeHandler = FastjsonTypeHandler.class)
    private List<Object> fileUrl;


}


