package com.yeejoin.amos.boot.module.hygf.api.dto;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.extension.handlers.FastjsonTypeHandler;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;

/**
 * 勘察信息
 *
 * @author system_generator
 * @date 2023-07-07
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "SurveyInformationDto", description = "勘察信息")
public class SurveyInformationDto extends BaseDto {

    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "勘察编号",example = "KC002JXSRYG202411071202")
    private String surveyNumber;

    @ApiModelProperty(value = "电站类型",example = "zx")
    private String powerStationType;

    @ApiModelProperty(value = "开发方名称",example = "MYSQL兼容经销商")
    private String developerName;

    @ApiModelProperty(value = "开发方code",example = "86*355*443*883")
    private String developerCode;
    @ApiModelProperty(value = "开发方平台id",example = "1815743601213181953")
    private Long developerId;
    @ApiModelProperty(value = " 业务员id",example = "1815743601213181953")
    private String salesmanId;

    @ApiModelProperty(value = "业务员名称",example = "admin")
    private String salesman;

    @ApiModelProperty(value = "制单人",example = "开发")
    private String creator;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "制单时间",example = "2024-11-07 13:51:17")
    private Date creatorTime;

    @ApiModelProperty(value = "业主类型",example = "jm")
    private String ownerType;

    @ApiModelProperty(value = " 审核状态 0未审核,1审核中，2审核结束",example = "0")
    private Integer review;

    @ApiModelProperty(value = "来源农户编号",example = "NH002JXSRYG20241107121128")
    private String peasantHouseholdNo;

    @ApiModelProperty(value = "业主姓名",example = "admin")
    private String ownersName;

    @ApiModelProperty(value = "联系电话",example = "13022982292")
    private String telephone;

    @ApiModelProperty(value = "身份证号",example = "610481199402245014")
    private String idCard;

    @ApiModelProperty(value = "邮箱",example = "212da@163.com")
    private String mailbox;

    @ApiModelProperty(value = "项目详细地址",example = "北京市/北京城区/东城区")
    private String projectAddressDetail;

    @ApiModelProperty(value = "常住详细地址",example = "北京市/北京城区/东城区")
    private String permanentAddressDetail;

    @ApiModelProperty(value = "项目地址code",example = "[110000, 110100, 110101]")
    @TableField(typeHandler = FastjsonTypeHandler.class)
    private List<Integer> projectAddress;

    @ApiModelProperty(value = "项目地址文字",example = "[\"北京市\", \"北京城区\", \"东城区\"]")
    @TableField(typeHandler = FastjsonTypeHandler.class)
    private List<String> projectAddressText;

    @ApiModelProperty(value = "项目地址",example = "北京市/北京城区/东城区")
    private String projectAddressName;
    @ApiModelProperty(value = "常住地址",example = "北京市/北京城区/东城区")
    private String permanentAddressName;
    @ApiModelProperty(value = "常住地址code",example = "[110000, 110100, 110101]")
    @TableField(typeHandler = FastjsonTypeHandler.class)
    private List<Integer> permanentAddress;

    @ApiModelProperty(value = "常住地址文字",example = "北京市/北京城区/东城区")
    @TableField(typeHandler = FastjsonTypeHandler.class)
    private List<String> permanentAddressText;

    @ApiModelProperty(value = "常住是否相同",example = "相同")
    private String isPermanent;


    @ApiModelProperty(value = "定金",example = "12.23")
    private Float deposit;

    @ApiModelProperty(value = "区域公司id",example = "1702215275253886977")
    @NotNull(message = "区域公司id不能为空")
    private Long regionalCompaniesSeq;

    @ApiModelProperty(value = "农户id",example = "1854346995112611841")
    private Long peasantHouseholdId;

    @ApiModelProperty(value = "身份证正面",example = "[{\"url\": \"/upload/common/F0DC9029F692D5D88F18CDAF8E45561.jpg\"}]")
    @TableField(typeHandler = FastjsonTypeHandler.class)
    private List<Object> idCardFront;

    @ApiModelProperty(value = "身份证反面",example = "[{\"url\": \"/upload/common/2F7BD22F5A557469FC484C5E3E62B56D.jpg\"}]")
    @TableField(typeHandler = FastjsonTypeHandler.class)
    private List<Object> idCardOpposite;

}
