package com.yeejoin.amos.boot.module.hygf.api.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.handlers.FastjsonTypeHandler;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import java.util.Date;
import java.util.List;

/**
 * 存量合同电站
 *
 * @author system_generator
 * @date 2024-10-18
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("hygf_history_peasant_household")
public class HistoryPeasantHousehold extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 农户姓名
     */
	@TableField("owners_name")
    private String ownersName;

    /**
     * 身份证号
     */
	@TableField("id_card")
    private String idCard;

    /**
     * 联系方式
     */
	@TableField("telephone")
    private String telephone;

    /**
     * 房屋地址
     */
	@TableField("house_address")
    private String houseAddress;

    /**
     * 并网容量
     */
	@TableField("basic_grid_capacity")
    private String basicGridCapacity;

    /**
     * 并网日期
     */
	@TableField("basic_grid_date")
    private String basicGridDate;

    /**
     * 农户编号
     */
	@TableField("peasant_household_no")
    private String peasantHouseholdNo;

    /**
     * 购电合同
     */
	@TableField("power_purchase_contract")
    private String powerPurchaseContract;

    /**
     * 租赁合同
     */
	@TableField("lease_contract")
    private String leaseContract;

    /**
     * 状态
     */
    @TableField("status")
    private String status;

    /**
     * 附件信息
     */
    @TableField(value = "file_url",typeHandler = FastjsonTypeHandler.class)
    private List<Object> fileUrl;

    /**
     * 省份
     */
    @TableField("province")
    private String province;
}
