package com.yeejoin.amos.boot.module.hygf.api.entity;

import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.Date;
import java.util.List;

/**
 * 施工电站工程信息
 *
 * @author system_generator
 * @date 2024-01-02
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName(value = "hygf_power_station_engineering_info",autoResultMap = true)
@ApiModel(value = "PowerStationEngineeringInfo",description = "施工电站工程信息")
public class PowerStationEngineeringInfo extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 组件规格
     */
    @ApiModelProperty(value = "组件规格",example = "540")
	@TableField("component_specification")
    private String componentSpecification;

    /**
     * 上网类型
     */
    @ApiModelProperty(value = "上网类型",example = "全额上网")
	@TableField("grid_connection_type")
    private String gridConnectionType;

    /**
     * 组件数量
     */
    @ApiModelProperty(value = "组件数量",example = "43")
	@TableField("component_quantity")
    private Integer componentQuantity;

    /**
     * 实际电量
     */
    @ApiModelProperty(value = "实际电量",example = "23.22")
    @TableField("real_scale")
    private Double realScale;

    /**
     * 逆变器数量
     */
    @ApiModelProperty(value = "逆变器数量",example = "43")
	@TableField("inverter_quantity")
    private Integer inverterQuantity;

    /**
     * 并网箱数量
     */
    @ApiModelProperty(value = "并网箱数量",example = "21")
	@TableField("grid_box_quantity")
    private Integer gridBoxQuantity;

    /**
     * 电缆规格
     */
    @ApiModelProperty(value = "电缆规格",example = "4x6")
	@TableField("cable_specification")
    private String cableSpecification;

    /**
     * 电站设计方案
     */
    @ApiModelProperty(value = "电站设计方案",example = "43")
	@TableField("power_station_design_plan")
    private String powerStationDesignPlan;

    /**
     * 屋顶类型
     */
    @ApiModelProperty(value = "屋顶类型",example = "平屋顶")
	@TableField("roof_type")
    private String roofType;

    /**
     * 组件类型
     */
    @ApiModelProperty(value = "组件类型",example = "单晶")
	@TableField("component_type")
    private String componentType;

    /**
     * 并网箱类型
     */
    @ApiModelProperty(value = "并网箱类型",example = "带计量表位")
	@TableField("grid_box_type")
    private String gridBoxType;

    /**
     * 并网箱功能
     */
    @ApiModelProperty(value = "并网箱功能",example = "一进一出")
	@TableField("grid_box_function")
    private String gridBoxFunction;

    /**
     *
     */
    @ApiModelProperty(value = "派工单Id",example = "1854410994177019905")
	@TableField("work_order_id")
    private Long workOrderId;

    /**
     *
     */
    @ApiModelProperty(value = "施工电站ID",example = "1854411671791996929")
	@TableField("work_order_power_station_id")
    private Long workOrderPowerStationId;

    @ApiModelProperty(value = "完成时间",example = "2024-11-19")
    @TableField(value = "completion_date",updateStrategy = FieldStrategy.IGNORED)
    @JsonFormat(pattern="yyyy-MM-dd")
    private Date completionDate;




    /**
     * 施工组件信息
     */
    @TableField(exist = false)
    @ApiModelProperty(value = "施工组件信息",example = "[{\"gl\":\"540W\",\"xlh\":\"*323\",\"wlbm\":\"\",\"bk\":\"\",\"id\":\"amos-timeuuid-1730961702464-5\",\"wlmc\":\"\",\"lx\":\"\",\"dcpgg\":\"\",\"dsm\":\"单面\"}]")
    private List<Object> constructionComponentInfo;

    /**
     * 施工逆变器信息
     */
    @ApiModelProperty(value = "施工逆变器信息",example = "[{\"xl\":\"\",\"gl\":\"10kW\",\"xlh\":\"3232\",\"wlbm\":\"\",\"id\":\"amos-timeuuid-1730961702464-2\",\"wlmc\":\"\",\"yzm\":\"\",\"xw\":\"\"}]")
    @TableField(exist = false)
    private List<Object>  constructionInverterInfo;

    /**
     * 施工采集器信息
     */
    @ApiModelProperty(value = "施工采集器信息",example = "[{\"xlh\":\"3232\",\"id\":\"amos-timeuuid-1730961702464-3\"}]")
    @TableField(exist = false)
    private List<Object> constructionCollectorBoxInfo;

    /**
     * 施工并网箱信息
     */
    @ApiModelProperty(value = "施工并网箱信息",example = "[{\"gl\":\"63A一进一出\",\"xlh\":\"*32323\",\"wlbm\":\"\",\"cz\":\"\",\"gn\":\"一进一出\",\"id\":\"amos-timeuuid-1730961702464-4\",\"wlmc\":\"\",\"lx\":\"带计量表位\",\"swms\":\"\",\"xw\":\"\"}]")
    @TableField(exist = false)
    private List<Object>  constructionGridBoxInfo;



    /**
     * 工程负责人
     */
    @ApiModelProperty(value = "工程负责人",example = "admin")
    @TableField(exist = false)
    private String projectRegionManager;

    /**
     * 工程负责人电话
     */
    @ApiModelProperty(value = "工程负责人电话",example = "13342224434")
    @TableField(exist = false)
    private String projectRegionManagerPhone;

    /**
     * 施工负责人
     */
    @ApiModelProperty(value = "施工负责人",example = "admin")
    @TableField(exist = false)
    private String constructionRegionManager;

    /**
     * 施工负责人电话
     */
    @ApiModelProperty(value = "施工负责人电话",example = "13342224434")
    @TableField(exist = false)
    private String constructionRegionManagerPhone;

}
