package com.yeejoin.amos.boot.module.hygf.api.mapper;

import com.yeejoin.amos.boot.module.hygf.api.config.UserEmpower;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;
import java.util.Map;

public interface StatisticsHomepageMapper {


  @UserEmpower(field ={"ph.regional_companies_code"},dealerField ={"hygf_peasant_household.developer_code"} ,fieldConditions ={"eq"} ,relationship="and")
  public   List<Map<String,Object>> surveyStatusTotal(@RequestParam(value = "developerCode") String developerCode, @RequestParam(value = "regionalCompaniesCode")String regionalCompaniesCode,  @RequestParam(value = "province")String province, @RequestParam(value = "city") String city,  @RequestParam(value = "district")String district);

  @UserEmpower(field ={"hygf_peasant_household.regional_companies_code"},dealerField ={"hygf_peasant_household.developer_code"} ,fieldConditions ={"eq"} ,relationship="and")
  public   int selectWKC(@RequestParam(value = "developerCode") String developerCode, @RequestParam(value = "regionalCompaniesCode")String regionalCompaniesCode,  @RequestParam(value = "province")String province, @RequestParam(value = "city") String city,  @RequestParam(value = "district")String district);

  @UserEmpower(field ={"ph.regional_companies_code"},dealerField ={"hygf_peasant_household.developer_code"} ,fieldConditions ={"eq"} ,relationship="and")
  public   List<Map<String,Object>> homePageExport(@RequestParam(value = "developerCode") String developerCode, @RequestParam(value = "regionalCompaniesCode")String regionalCompaniesCode,  @RequestParam(value = "province")String province, @RequestParam(value = "city") String city,  @RequestParam(value = "district")String district);

  @UserEmpower(field ={"b.regionalCompaniesCode"},dealerField ={"hygf_peasant_household.developer_code"} ,fieldConditions ={"eq"} ,relationship="and")
  public   List<Map<String,Object>> merCount(@RequestParam(value = "developerCode") String developerCode, @RequestParam(value = "regionalCompaniesCode")String regionalCompaniesCode,  @RequestParam(value = "province")String province, @RequestParam(value = "city") String city,  @RequestParam(value = "district")String district);

  @UserEmpower(field ={"ph.regional_companies_code"},dealerField ={"hygf_peasant_household.developer_code"} ,fieldConditions ={"eq"} ,relationship="and")
  public  List<Map<String,Object>> contractStatusTotal(@RequestParam(value = "developerCode") String developerCode, @RequestParam(value = "regionalCompaniesCode")String regionalCompaniesCode,  @RequestParam(value = "province")String province, @RequestParam(value = "city") String city,  @RequestParam(value = "district")String district);
  @UserEmpower(field ={"hygf_peasant_household.regional_companies_code"},dealerField ={"hygf_peasant_household.developer_code"} ,fieldConditions ={"eq"} ,relationship="and")
  public  List<Map<String,Object>> desionTotal(@RequestParam(value = "developerCode") String developerCode, @RequestParam(value = "regionalCompaniesCode")String regionalCompaniesCode,  @RequestParam(value = "province")String province, @RequestParam(value = "city") String city,  @RequestParam(value = "district")String district);
  @UserEmpower(field ={"hygf_peasant_household.regional_companies_code"},dealerField ={"hygf_peasant_household.developer_code"} ,fieldConditions ={"eq"} ,relationship="and")
  public  List<Map<String,Object>> preparationMoneyTotal(@RequestParam(value = "developerCode") String developerCode, @RequestParam(value = "regionalCompaniesCode")String regionalCompaniesCode,  @RequestParam(value = "province")String province, @RequestParam(value = "city") String city,  @RequestParam(value = "district")String district);
  @UserEmpower(field ={"hygf_peasant_household.regional_companies_code"},dealerField ={"hygf_peasant_household.developer_code"} ,fieldConditions ={"eq"} ,relationship="and")
  public  List<Map<String,Object>> workOrderTotal(@RequestParam(value = "developerCode") String developerCode, @RequestParam(value = "regionalCompaniesCode")String regionalCompaniesCode,  @RequestParam(value = "province")String province, @RequestParam(value = "city") String city,  @RequestParam(value = "district")String district);
  @UserEmpower(field ={"hygf_peasant_household.regional_companies_code"},dealerField ={"hygf_peasant_household.developer_code"} ,fieldConditions ={"eq"} ,relationship="and")
  public  List<Map<String,Object>> gridStatusTotal(@RequestParam(value = "developerCode") String developerCode, @RequestParam(value = "regionalCompaniesCode")String regionalCompaniesCode,  @RequestParam(value = "province")String province, @RequestParam(value = "city") String city,  @RequestParam(value = "district")String district);
  @UserEmpower(field ={"hygf_peasant_household.regional_companies_code"},dealerField ={"hygf_peasant_household.developer_code"} ,fieldConditions ={"eq"} ,relationship="and")
  public  List<Map<String,Object>> acceptanceStatusTotal(@RequestParam(value = "developerCode") String developerCode, @RequestParam(value = "regionalCompaniesCode")String regionalCompaniesCode,  @RequestParam(value = "province")String province, @RequestParam(value = "city") String city,  @RequestParam(value = "district")String district);
  @UserEmpower(field ={"hph.regional_companies_code"},dealerField ={"hygf_peasant_household.developer_code"} ,fieldConditions ={"eq"} ,relationship="and")
  public  List<Map<String,Object>> financingStatusTotal(@RequestParam(value = "developerCode") String developerCode, @RequestParam(value = "regionalCompaniesCode")String regionalCompaniesCode,  @RequestParam(value = "province")String province, @RequestParam(value = "city") String city,  @RequestParam(value = "district")String district);
  @UserEmpower(field ={"hygf_peasant_household.regional_companies_code"},dealerField ={"hygf_peasant_household.developer_code"} ,fieldConditions ={"eq"} ,relationship="and")
  public  List<Map<String,Object>> inverterTotal(@RequestParam(value = "developerCode") String developerCode, @RequestParam(value = "regionalCompaniesCode")String regionalCompaniesCode,  @RequestParam(value = "province")String province, @RequestParam(value = "city") String city,  @RequestParam(value = "district")String district,  @RequestParam(value = "regions")List<String> regions);
  @UserEmpower(field ={"jp.regional_companies_code"},dealerField ={"hygf_peasant_household.developer_code"} ,fieldConditions ={"eq"} ,relationship="and")
  public  List<Map<String,Object>> inverterTotalJp(@RequestParam(value = "developerCode") String developerCode, @RequestParam(value = "regionalCompaniesCode")String regionalCompaniesCode,  @RequestParam(value = "province")String province, @RequestParam(value = "city") String city,  @RequestParam(value = "district")String district,  @RequestParam(value = "regions")List<String> regions);
  @UserEmpower(field ={"hygf_peasant_household.regional_companies_code"},dealerField ={"hygf_peasant_household.developer_code"} ,fieldConditions ={"eq"} ,relationship="and")
  public Map<String,Object> stationNum(String developerCode, String regionalCompaniesCode, String province, String city, String district);

  @UserEmpower(field ={"ph.regional_companies_code"},dealerField ={"hygf_peasant_household.developer_code"} ,fieldConditions ={"eq"} ,relationship="and")
  public Map<String,Object> statisticsPowerStation(String developerCode, String regionalCompaniesCode, String province, String city, String district);
  @UserEmpower(field ={"hygf_peasant_household.regional_companies_code"},dealerField ={"hygf_peasant_household.developer_code"} ,fieldConditions ={"eq"} ,relationship="and")
  public Map<String,Object> statisticsPreparationMoney(String developerCode, String regionalCompaniesCode, String province, String city, String district);

  public String selectProvince (String regionSeq);
  @UserEmpower(field ={"hygf_repayment.regional_companies_code"},dealerField ={"hygf_peasant_household.developer_code"} ,fieldConditions ={"eq"} ,relationship="and")
  public  List<Map<String,Object>> getRent (@RequestParam(value = "regionalCompaniesCode") String regionalCompaniesCode, @RequestParam(value = "regions")List<String> regions);


}
